/*
 * Decompiled with CFR 0.152.
 */
package engineer.forms.vanilla;

import engineer.forms.vanilla.FormContentIconButtonShaded;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.Settings;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.client.Client;
import necesse.gfx.forms.components.FormBreakLine;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.FormSlider;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.presets.containerComponent.logicGate.LogicGateContainerForm;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.inventory.container.logicGate.TimerLogicGateContainer;
import necesse.level.gameLogicGate.entities.LogicGateEntity;

public class NewTimerLogicGateContainerForm<T extends TimerLogicGateContainer>
extends LogicGateContainerForm<T> {
    private final GameEventListener<LogicGateEntity.ApplyPacketEvent> applyListener;

    public NewTimerLogicGateContainerForm(Client client, final T container) {
        super(client, 400, 160, container);
        this.addComponent((FormComponent)new FormLocalLabel(((TimerLogicGateContainer)container).entity.getLogicGate().getLocalization(), new FontOptions(20), -1, 4, 4));
        this.addComponent((FormComponent)new FormContentIconButtonShaded(this.getWidth() - 25, 5, FormInputSize.SIZE_20, ButtonColor.BASE, (ButtonTexture)Settings.UI.button_help_20, new GameMessage[]{new LocalMessage("ui", "timergatelogictip")}));
        this.addWireCheckboxes(10, 40, (GameMessage)new LocalMessage("ui", "wireinputs"), (LogicGateEntity)((TimerLogicGateContainer)container).entity, e -> e.wireInputs, ((TimerLogicGateContainer)container).setInputs);
        this.addComponent((FormComponent)new FormBreakLine(FormBreakLine.ALIGN_BEGINNING, 135, 45, 100, false));
        this.addWireCheckboxes(150, 40, (GameMessage)new LocalMessage("ui", "wireoutputs"), (LogicGateEntity)((TimerLogicGateContainer)container).entity, e -> e.wireOutputs, ((TimerLogicGateContainer)container).setOutputs);
        this.addComponent((FormComponent)new FormBreakLine(FormBreakLine.ALIGN_BEGINNING, 265, 45, 100, false));
        this.addComponent((FormComponent)new FormLocalLabel("ui", "timerticks", new FontOptions(16), -1, 280, 40));
        final FormSlider ticks = ((FormSlider)this.addComponent((FormComponent)new FormSlider("", 280, 65, ((TimerLogicGateContainer)container).entity.timerTicks, 10, 200, 100))).onGrab(e -> {
            if (!e.grabbed) {
                container.setTicks.runAndSend(((FormSlider)e.from).getValue());
            }
        });
        ticks.onScroll(e -> container.setTicks.runAndSend(((FormSlider)e.from).getValue()));
        ticks.drawValueInPercent = false;
        this.addComponent((FormComponent)new FormLocalLabel((GameMessage)new LocalMessage("ui", "timertip", new Object[]{"ticks", 20}), new FontOptions(12), -1, 280, ticks.getY() + ticks.getTotalHeight() + 5, 100));
        this.applyListener = (GameEventListener)((TimerLogicGateContainer)container).entity.applyPacketEvents.addListener((GameEventInterface)new GameEventListener<LogicGateEntity.ApplyPacketEvent>(){

            public void onEvent(LogicGateEntity.ApplyPacketEvent event) {
                ticks.setValue(container.entity.timerTicks);
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.applyListener.dispose();
    }
}

