/*
 * Decompiled with CFR 0.152.
 */
package engineer.forms.vanilla;

import engineer.forms.vanilla.FormContentIconButtonShaded;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.Settings;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.client.Client;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormHorizontalIntScroll;
import necesse.gfx.forms.components.FormHorizontalScroll;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.lists.FormStringSelectList;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.presets.containerComponent.logicGate.LogicGateContainerForm;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.inventory.container.logicGate.SoundLogicGateContainer;
import necesse.level.gameLogicGate.entities.LogicGateEntity;
import necesse.level.gameLogicGate.entities.SoundLogicGateEntity;

public class NewSoundLogicGateContainerForm<T extends SoundLogicGateContainer>
extends LogicGateContainerForm<T> {
    private final GameEventListener<LogicGateEntity.ApplyPacketEvent> applyListener;
    public FormStringSelectList sounds;
    public FormHorizontalIntScroll semitone;

    public NewSoundLogicGateContainerForm(Client client, final T container) {
        super(client, 400, 160, container);
        this.addComponent((FormComponent)new FormLocalLabel(((SoundLogicGateContainer)container).entity.getLogicGate().getLocalization(), new FontOptions(20), -1, 4, 4));
        this.addComponent((FormComponent)new FormContentIconButtonShaded(this.getWidth() - 25, 5, FormInputSize.SIZE_20, ButtonColor.BASE, (ButtonTexture)Settings.UI.button_help_20, new GameMessage[]{new LocalMessage("ui", "soundgatelogictip")}));
        this.sounds = (FormStringSelectList)this.addComponent((FormComponent)new FormStringSelectList(0, 40, 160, this.getHeight() - 40, SoundLogicGateEntity.getSoundNames()));
        this.sounds.setSelected(((SoundLogicGateContainer)container).entity.sound);
        this.sounds.onSelect(e -> {
            this.playTest();
            container.setSound.runAndSend(e.index);
        });
        this.addComponent((FormComponent)new FormLocalLabel("ui", "soundsemitone", new FontOptions(16), 0, 250, 50));
        this.semitone = (FormHorizontalIntScroll)this.addComponent((FormComponent)new FormHorizontalIntScroll(220, 75, 60, FormHorizontalScroll.DrawOption.value, (GameMessage)new LocalMessage("ui", "soundsemitone"), ((SoundLogicGateContainer)container).entity.semitone, -12, 12));
        this.semitone.onChanged(e -> {
            this.playTest();
            container.setSemitone.runAndSend(((Integer)((FormHorizontalScroll)e.from).getValue()).intValue());
        });
        this.applyListener = (GameEventListener)((SoundLogicGateContainer)container).entity.applyPacketEvents.addListener((GameEventInterface)new GameEventListener<LogicGateEntity.ApplyPacketEvent>(){

            public void onEvent(LogicGateEntity.ApplyPacketEvent event) {
                NewSoundLogicGateContainerForm.this.sounds.setSelected(container.entity.sound);
                NewSoundLogicGateContainerForm.this.semitone.setValue((Object)container.entity.semitone);
            }
        });
    }

    public void playTest() {
        int sound = this.sounds.getSelectedIndex();
        SoundLogicGateEntity.playSound((int)sound, (int)((Integer)this.semitone.getValue()), (int)(((SoundLogicGateContainer)this.container).entity.tileX * 32 + 16), (int)(((SoundLogicGateContainer)this.container).entity.tileY * 32 + 16));
    }

    public void dispose() {
        super.dispose();
        this.applyListener.dispose();
    }
}

