/*
 * Decompiled with CFR 0.152.
 */
package engineer.forms.vanilla;

import engineer.forms.vanilla.FormContentIconButtonShaded;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.List;
import necesse.engine.GameEventInterface;
import necesse.engine.GameEventListener;
import necesse.engine.GameTileRange;
import necesse.engine.Settings;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.client.Client;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.Renderer;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.SharedTextureDrawOptions;
import necesse.gfx.drawables.SortedDrawable;
import necesse.gfx.forms.components.FormBreakLine;
import necesse.gfx.forms.components.FormCheckBox;
import necesse.gfx.forms.components.FormComponent;
import necesse.gfx.forms.components.FormHorizontalIntScroll;
import necesse.gfx.forms.components.FormHorizontalScroll;
import necesse.gfx.forms.components.FormInputSize;
import necesse.gfx.forms.components.localComponents.FormLocalCheckBox;
import necesse.gfx.forms.components.localComponents.FormLocalLabel;
import necesse.gfx.forms.presets.containerComponent.logicGate.LogicGateContainerForm;
import necesse.gfx.gameFont.FontOptions;
import necesse.gfx.ui.ButtonColor;
import necesse.gfx.ui.ButtonTexture;
import necesse.inventory.container.logicGate.SensorLogicGateContainer;
import necesse.level.gameLogicGate.entities.LogicGateEntity;
import necesse.level.gameLogicGate.entities.SensorLogicGateEntity;
import necesse.level.maps.hudManager.HudDrawElement;

public class NewSensorLogicGateContainerForm<T extends SensorLogicGateContainer>
extends LogicGateContainerForm<T> {
    protected HudDrawElement rangeElement;
    protected FormHorizontalScroll<Integer> rangeSelector;
    protected final GameEventListener<LogicGateEntity.ApplyPacketEvent> applyListener;

    public NewSensorLogicGateContainerForm(Client client, final T container) {
        super(client, 400, 160, container);
        this.addComponent((FormComponent)new FormLocalLabel(((SensorLogicGateContainer)container).entity.getLogicGate().getLocalization(), new FontOptions(20), -1, 4, 4));
        this.addComponent((FormComponent)new FormContentIconButtonShaded(this.getWidth() - 25, 5, FormInputSize.SIZE_20, ButtonColor.BASE, (ButtonTexture)Settings.UI.button_help_20, new GameMessage[]{new LocalMessage("ui", "sensorgatelogictip")}));
        this.addWireCheckboxes(10, 40, (GameMessage)new LocalMessage("ui", "wireoutputs"), (LogicGateEntity)((SensorLogicGateContainer)container).entity, e -> e.wireOutputs, ((SensorLogicGateContainer)container).setOutputs);
        this.addComponent((FormComponent)new FormBreakLine(FormBreakLine.ALIGN_BEGINNING, 150, 45, 100, false));
        this.addComponent((FormComponent)new FormLocalLabel((GameMessage)new LocalMessage("ui", "sensorlabel"), new FontOptions(20), -1, 160, 40));
        final FormCheckBox players = ((FormLocalCheckBox)this.addComponent((FormComponent)new FormLocalCheckBox("ui", "sensorplayers", 160, 65, ((SensorLogicGateContainer)container).entity.players))).onClicked(e -> container.setPlayers.runAndSend(((FormCheckBox)e.from).checked));
        final FormCheckBox hostileMobs = ((FormLocalCheckBox)this.addComponent((FormComponent)new FormLocalCheckBox("ui", "sensorhostile", 160, 85, ((SensorLogicGateContainer)container).entity.hostileMobs))).onClicked(e -> container.setHostileMobs.runAndSend(((FormCheckBox)e.from).checked));
        final FormCheckBox passiveMobs = ((FormLocalCheckBox)this.addComponent((FormComponent)new FormLocalCheckBox("ui", "sensorpassive", 160, 105, ((SensorLogicGateContainer)container).entity.passiveMobs))).onClicked(e -> container.setPassiveMobs.runAndSend(((FormCheckBox)e.from).checked));
        this.rangeSelector = ((FormHorizontalIntScroll)this.addComponent((FormComponent)new FormHorizontalIntScroll(160, 125, 100, FormHorizontalScroll.DrawOption.valueOnHover, (GameMessage)new LocalMessage("ui", "sensorrange"), ((SensorLogicGateContainer)container).entity.range, 1, SensorLogicGateEntity.MAX_RANGE))).onChanged(e -> container.setRange.runAndSend(((Integer)((FormHorizontalScroll)e.from).getValue()).intValue()));
        this.applyListener = (GameEventListener)((SensorLogicGateContainer)container).entity.applyPacketEvents.addListener((GameEventInterface)new GameEventListener<LogicGateEntity.ApplyPacketEvent>(){

            public void onEvent(LogicGateEntity.ApplyPacketEvent event) {
                players.checked = container.entity.players;
                hostileMobs.checked = container.entity.hostileMobs;
                passiveMobs.checked = container.entity.passiveMobs;
                NewSensorLogicGateContainerForm.this.rangeSelector.setValue((Object)container.entity.range);
            }
        });
    }

    protected void init() {
        super.init();
        if (this.rangeElement != null) {
            this.rangeElement.remove();
        }
        this.rangeElement = new HudDrawElement(){

            public void addDrawables(List<SortedDrawable> list, GameCamera camera, PlayerMob perspective) {
                GameTileRange tileRange;
                SharedTextureDrawOptions options;
                if (NewSensorLogicGateContainerForm.this.rangeSelector.isHovering() && (options = (tileRange = SensorLogicGateEntity.getTileRange((int)((SensorLogicGateContainer)((NewSensorLogicGateContainerForm)NewSensorLogicGateContainerForm.this).container).entity.range)).getDrawOptions(new Color(255, 255, 255, 200), new Color(255, 255, 255, 75), ((SensorLogicGateContainer)((NewSensorLogicGateContainerForm)NewSensorLogicGateContainerForm.this).container).entity.tileX, ((SensorLogicGateContainer)((NewSensorLogicGateContainerForm)NewSensorLogicGateContainerForm.this).container).entity.tileY, camera)) != null) {
                    list.add(new SortedDrawable(){

                        public int getPriority() {
                            return -1000000;
                        }

                        public void draw(TickManager tickManager) {
                            options.draw();
                        }
                    });
                }
            }
        };
        this.client.getLevel().hudManager.addElement(this.rangeElement);
    }

    public void draw(TickManager tickManager, PlayerMob perspective, Rectangle renderBox) {
        if (this.rangeSelector.isHovering()) {
            Renderer.hudManager.fadeHUD();
        }
        super.draw(tickManager, perspective, renderBox);
    }

    public void dispose() {
        super.dispose();
        this.applyListener.dispose();
        if (this.rangeElement != null) {
            this.rangeElement.remove();
        }
    }
}

