/*
 * Decompiled with CFR 0.152.
 */
package engineer.forms.storage;

import engineer.objects.logic.StorageLogicGateEntity;
import java.awt.Point;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameMath;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.inventory.PlaceableItemInterface;
import necesse.inventory.container.Container;
import necesse.inventory.container.customAction.BooleanCustomAction;
import necesse.inventory.container.customAction.ContainerCustomAction;
import necesse.inventory.container.customAction.IntCustomAction;

public class StorageLogicGateContainer
extends Container {
    public StorageLogicGateEntity entity;
    public final IntCustomAction setRedTriggerSlots;
    public final IntCustomAction setGreenTriggerSlots;
    public final IntCustomAction setBlueTriggerSlots;
    public final IntCustomAction setYellowTriggerSlots;
    public final BooleanCustomAction setRedInverted;
    public final BooleanCustomAction setGreenInverted;
    public final BooleanCustomAction setBlueInverted;
    public final BooleanCustomAction setYellowInverted;

    public StorageLogicGateContainer(final NetworkClient client, int uniqueSeed, final StorageLogicGateEntity entity) {
        super(client, uniqueSeed);
        this.entity = entity;
        this.setRedTriggerSlots = (IntCustomAction)this.registerAction((ContainerCustomAction)new IntCustomAction(){

            protected void run(int value) {
                entity.redTrigger = GameMath.limit((int)value, (int)0, (int)entity.foundSlots);
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setGreenTriggerSlots = (IntCustomAction)this.registerAction((ContainerCustomAction)new IntCustomAction(){

            protected void run(int value) {
                entity.greenTrigger = GameMath.limit((int)value, (int)0, (int)entity.foundSlots);
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setBlueTriggerSlots = (IntCustomAction)this.registerAction((ContainerCustomAction)new IntCustomAction(){

            protected void run(int value) {
                entity.blueTrigger = GameMath.limit((int)value, (int)0, (int)entity.foundSlots);
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setYellowTriggerSlots = (IntCustomAction)this.registerAction((ContainerCustomAction)new IntCustomAction(){

            protected void run(int value) {
                entity.yellowTrigger = GameMath.limit((int)value, (int)0, (int)entity.foundSlots);
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setRedInverted = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.redInverted = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setGreenInverted = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.greenInverted = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setBlueInverted = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.blueInverted = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setYellowInverted = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.yellowInverted = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid(ServerClient client) {
        if (!super.isValid(client)) {
            return false;
        }
        if (this.entity.isRemoved()) return false;
        Point point = new Point(this.entity.tileX * 32 + 16, this.entity.tileY * 32 + 16);
        if (!(point.distance(client.playerMob.getX(), client.playerMob.getY()) <= (double)PlaceableItemInterface.getPlaceRange((ItemAttackerMob)client.playerMob))) return false;
        return true;
    }
}

