/*
 * Decompiled with CFR 0.152.
 */
package engineer.forms.lightGenerator;

import engineer.objects.logic.LightGeneratorLogicGateEntity;
import java.awt.Point;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.inventory.PlaceableItemInterface;
import necesse.inventory.container.Container;
import necesse.inventory.container.customAction.BooleanCustomAction;
import necesse.inventory.container.customAction.ContainerCustomAction;
import necesse.inventory.container.logicGate.WireSelectCustomAction;

public class LightGeneratorLogicGateContainer
extends Container {
    public LightGeneratorLogicGateEntity entity;
    public final WireSelectCustomAction setInputs;
    public final BooleanCustomAction setinverted;

    public LightGeneratorLogicGateContainer(final NetworkClient client, int uniqueSeed, final LightGeneratorLogicGateEntity entity) {
        super(client, uniqueSeed);
        this.entity = entity;
        this.setInputs = (WireSelectCustomAction)this.registerAction((ContainerCustomAction)new WireSelectCustomAction(){

            protected void run(boolean[] wires) {
                entity.wireInputs = wires;
                if (client.isServer()) {
                    entity.updateOutputs(false);
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setinverted = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.inverted = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid(ServerClient client) {
        if (!super.isValid(client)) {
            return false;
        }
        if (this.entity.isRemoved()) return false;
        Point point = new Point(this.entity.tileX * 32 + 16, this.entity.tileY * 32 + 16);
        if (!(point.distance(client.playerMob.getX(), client.playerMob.getY()) <= (double)PlaceableItemInterface.getPlaceRange((ItemAttackerMob)client.playerMob))) return false;
        return true;
    }
}

