/*
 * Decompiled with CFR 0.152.
 */
package engineer.forms.light;

import engineer.objects.logic.ProjectileLogicGateEntity;
import java.awt.Point;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameMath;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.inventory.PlaceableItemInterface;
import necesse.inventory.container.Container;
import necesse.inventory.container.customAction.BooleanCustomAction;
import necesse.inventory.container.customAction.ContainerCustomAction;
import necesse.inventory.container.customAction.IntCustomAction;
import necesse.inventory.container.logicGate.WireSelectCustomAction;

public class ProjectileLogicGateContainer
extends Container {
    public ProjectileLogicGateEntity entity;
    public final WireSelectCustomAction setOutputs;
    public final IntCustomAction setRange;
    public final BooleanCustomAction setPlayer;
    public final BooleanCustomAction setMob;
    public final BooleanCustomAction setDamage;
    public final BooleanCustomAction setTrap;
    public final BooleanCustomAction setOther;
    public final BooleanCustomAction setinverted;

    public ProjectileLogicGateContainer(final NetworkClient client, int uniqueSeed, final ProjectileLogicGateEntity entity) {
        super(client, uniqueSeed);
        this.entity = entity;
        this.setOutputs = (WireSelectCustomAction)this.registerAction((ContainerCustomAction)new WireSelectCustomAction(){

            protected void run(boolean[] wires) {
                entity.wireOutputs = wires;
                if (client.isServer()) {
                    entity.updateOutputs(false);
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setRange = (IntCustomAction)this.registerAction((ContainerCustomAction)new IntCustomAction(){

            protected void run(int value) {
                entity.range = GameMath.limit((int)value, (int)1, (int)5);
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setPlayer = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.fromPlayer = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setMob = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.fromMob = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setDamage = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.fromDamaging = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setTrap = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.fromTrap = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setOther = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.fromOther = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setinverted = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.inverted = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid(ServerClient client) {
        if (!super.isValid(client)) {
            return false;
        }
        if (this.entity.isRemoved()) return false;
        Point point = new Point(this.entity.tileX * 32 + 16, this.entity.tileY * 32 + 16);
        if (!(point.distance(client.playerMob.getX(), client.playerMob.getY()) <= (double)PlaceableItemInterface.getPlaceRange((ItemAttackerMob)client.playerMob))) return false;
        return true;
    }
}

