/*
 * Decompiled with CFR 0.152.
 */
package engineer.forms.light;

import engineer.objects.logic.LightLogicGateEntity;
import java.awt.Point;
import necesse.engine.network.NetworkClient;
import necesse.engine.network.server.ServerClient;
import necesse.engine.util.GameMath;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.inventory.PlaceableItemInterface;
import necesse.inventory.container.Container;
import necesse.inventory.container.customAction.BooleanCustomAction;
import necesse.inventory.container.customAction.ContainerCustomAction;
import necesse.inventory.container.customAction.IntCustomAction;
import necesse.inventory.container.logicGate.WireSelectCustomAction;

public class LightLogicGateContainer
extends Container {
    public LightLogicGateEntity entity;
    public final WireSelectCustomAction setOutputs;
    public final IntCustomAction setLight;
    public final BooleanCustomAction setinverted;

    public LightLogicGateContainer(final NetworkClient client, int uniqueSeed, final LightLogicGateEntity entity) {
        super(client, uniqueSeed);
        this.entity = entity;
        this.setOutputs = (WireSelectCustomAction)this.registerAction((ContainerCustomAction)new WireSelectCustomAction(){

            protected void run(boolean[] wires) {
                entity.wireOutputs = wires;
                if (client.isServer()) {
                    entity.updateOutputs(false);
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setLight = (IntCustomAction)this.registerAction((ContainerCustomAction)new IntCustomAction(){

            protected void run(int value) {
                entity.light = GameMath.limit((int)value, (int)0, (int)15);
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
        this.setinverted = (BooleanCustomAction)this.registerAction((ContainerCustomAction)new BooleanCustomAction(){

            protected void run(boolean value) {
                entity.inverted = value;
                if (client.isServer()) {
                    entity.sendUpdatePacket();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid(ServerClient client) {
        if (!super.isValid(client)) {
            return false;
        }
        if (this.entity.isRemoved()) return false;
        Point point = new Point(this.entity.tileX * 32 + 16, this.entity.tileY * 32 + 16);
        if (!(point.distance(client.playerMob.getX(), client.playerMob.getY()) <= (double)PlaceableItemInterface.getPlaceRange((ItemAttackerMob)client.playerMob))) return false;
        return true;
    }
}

