/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.scripts;

import java.awt.geom.Point2D;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketFireShardCannon;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.ai.behaviourTree.leaves.ChaserAINode;
import necesse.entity.mobs.attackHandler.MouseAngleAttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameResources;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rangedarsenal.items.weapons.ShardCannonRework;

public class ShardCannonAttackHandlerFix
extends MouseAngleAttackHandler {
    private final InventoryItem item;
    private final ShardCannonRework toolItem;
    private long lastTime;
    private long timeBuffer;
    private final int attackSeed;
    private int shots;
    private final GameRandom random = new GameRandom();

    public ShardCannonAttackHandlerFix(ItemAttackerMob attackerMob, ItemAttackSlot slot, InventoryItem item, ShardCannonRework toolItem, int seed, int startTargetX, int startTargetY) {
        super(attackerMob, slot, 50, 1000.0f, startTargetX, startTargetY);
        this.item = item;
        this.toolItem = toolItem;
        this.attackSeed = seed;
        this.lastTime = attackerMob.getLocalTime();
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.attackerMob.isPlayer && this.lastItemAttackerTarget != null && !ChaserAINode.hasLineOfSightToTarget((Mob)this.attackerMob, (Mob)this.lastItemAttackerTarget, (float)5.0f)) {
            this.attackerMob.endAttackHandler(true);
        } else {
            Point2D.Float dir = GameMath.getAngleDir((float)this.currentAngle);
            int attackX = this.attackerMob.getX() + (int)(dir.x * 100.0f);
            int attackY = this.attackerMob.getY() + (int)(dir.y * 100.0f);
            long currentTime = this.attackerMob.getLevel().getLocalTime();
            if (this.toolItem.canAttack(this.attackerMob.getLevel(), attackX, attackY, this.attackerMob, this.item) == null) {
                int cooldown;
                this.timeBuffer += currentTime - this.lastTime;
                int seed = Item.getRandomAttackSeed((GameRandom)this.random.seeded((long)GameRandom.prime((int)(this.attackSeed * this.shots))));
                GNDItemMap attackMap = this.attackerMob.showAttackAndSendAttacker(this.item, attackX, attackY, 0, seed);
                while (this.timeBuffer >= (long)(cooldown = this.getShootCooldown())) {
                    this.timeBuffer -= (long)cooldown;
                    seed = Item.getRandomAttackSeed((GameRandom)this.random.nextSeeded(GameRandom.prime((int)(this.attackSeed * this.shots))));
                    ++this.shots;
                    this.toolItem.superOnAttack(this.attackerMob.getLevel(), attackX, attackY, this.attackerMob, this.attackerMob.getCurrentAttackHeight(), this.item, this.slot, 0, seed, attackMap);
                    if (this.attackerMob.isClient()) {
                        if (this.attackerMob.buffManager.hasBuff("ShardCannonCooldownDebuff")) {
                            SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(1.5f, 1.75f)));
                            SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(1.0f, 1.5f)));
                            SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(0.7f, 1.0f)));
                            SoundManager.playSound((GameSound)((GameSound)GameRandom.globalRandom.getOneOf((Object[])new GameSound[]{GameResources.crystalHit2, GameResources.crystalHit3})), (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(1.2f).pitch(GameRandom.globalRandom.getFloatBetween(0.9f, 1.1f)));
                            continue;
                        }
                        SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(3.0f).pitch(GameRandom.globalRandom.getFloatBetween(1.5f, 1.75f)));
                        SoundManager.playSound((GameSound)((GameSound)GameRandom.globalRandom.getOneOf((Object[])new GameSound[]{GameResources.crystalHit2, GameResources.crystalHit3})), (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(2.0f).pitch(GameRandom.globalRandom.getFloatBetween(0.9f, 1.1f)));
                        continue;
                    }
                    if (!this.attackerMob.isServer()) continue;
                    this.attackerMob.sendAttackerPacket((RegionPositionGetter)this.attackerMob, (Packet)new PacketFireShardCannon((Mob)this.attackerMob));
                }
            }
            this.lastTime = currentTime;
        }
    }

    private int getShootCooldown() {
        if (this.attackerMob.buffManager.hasBuff("ShardCannonCooldownDebuff")) {
            float multiplier = 3.0f / this.toolItem.getAttackSpeedModifier(this.item, this.attackerMob);
            return (int)(multiplier * 150.0f);
        }
        float multiplier = 1.0f / this.toolItem.getAttackSpeedModifier(this.item, this.attackerMob);
        return (int)(multiplier * 150.0f);
    }

    public void onEndAttack(boolean bySelf) {
        this.attackerMob.doAndSendStopAttackAttacker(false);
    }
}

