/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.scripts;

import java.awt.Color;
import java.awt.geom.Point2D;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.mobs.attackHandler.MouseAngleAttackHandler;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.inventory.InventoryItem;
import rangedarsenal.items.weapons.SapphireRevolverRework;

public class SapphireRevolverAttackHandlerRework
extends MouseAngleAttackHandler {
    public int chargeDelay = 1000;
    private final long startTime;
    public SapphireRevolverRework toolItem;
    public InventoryItem item;
    private final int seed;
    private boolean charged;
    private boolean charged2;
    private boolean charged3;
    private float tier;
    protected int endAttackBuffer;

    public SapphireRevolverAttackHandlerRework(ItemAttackerMob attackerMob, ItemAttackSlot slot, InventoryItem item, SapphireRevolverRework toolItem, int seed, int startTargetX, int startTargetY, float tier) {
        super(attackerMob, slot, 20, 1000.0f, startTargetX, startTargetY);
        this.item = item;
        this.toolItem = toolItem;
        this.seed = seed;
        this.startTime = attackerMob.getWorldEntity().getLocalTime();
        this.chargeDelay = seed;
        this.tier = tier;
    }

    public long getTimeSinceStart() {
        return this.attackerMob.getWorldEntity().getLocalTime() - this.startTime;
    }

    public float getChargePercent() {
        return Math.min((float)this.getTimeSinceStart() / this.getChargeTime(), 3.0f);
    }

    public float getChargeTime() {
        float multiplier = Math.max(1.0f - this.tier / 10.0f, 0.4f) / this.toolItem.getAttackSpeedModifier(this.item, this.attackerMob);
        return (int)(multiplier * 1000.0f);
    }

    public void onUpdate() {
        block5: {
            block7: {
                block6: {
                    super.onUpdate();
                    float chargePercent = this.getChargePercent();
                    if (!this.attackerMob.isPlayer && chargePercent >= 1.0f) {
                        this.endAttackBuffer += this.updateInterval;
                        if (this.endAttackBuffer >= 350) {
                            this.endAttackBuffer = 0;
                            this.attackerMob.endAttackHandler(true);
                            return;
                        }
                    }
                    Point2D.Float dir = GameMath.getAngleDir((float)this.currentAngle);
                    int attackX = this.attackerMob.getX() + (int)(dir.x * 100.0f);
                    int attackY = this.attackerMob.getY() + (int)(dir.y * 100.0f);
                    if (this.toolItem.canAttack(this.attackerMob.getLevel(), attackX, attackY, this.attackerMob, this.item) != null) break block5;
                    this.attackerMob.showAttackAndSendAttacker(this.item, attackX, attackY, 0, this.seed);
                    if (!this.attackerMob.isClient() || !(this.getChargePercent() >= 3.0f) || this.charged3) break block6;
                    this.charged3 = true;
                    SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(1.0f).pitch(2.0f));
                    SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(1.0f).pitch(1.0f));
                    ParticleTypeSwitcher typeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.CRITICAL, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC});
                    float anglePerParticle = 12.0f;
                    for (int i = 0; i < 30; ++i) {
                        int angle = (int)((float)i * anglePerParticle + GameRandom.globalRandom.nextFloat() * anglePerParticle);
                        float dx = (float)Math.sin(Math.toRadians(angle)) * 50.0f;
                        float dy = (float)Math.cos(Math.toRadians(angle)) * 50.0f * 0.8f;
                        this.attackerMob.getLevel().entityManager.addParticle((Entity)this.attackerMob, typeSwitcher.next()).movesFriction(dx, dy, 0.8f).color(new Color(253, 44, 44)).heightMoves(0.0f, 10.0f).sizeFades(22, 44).sprite(GameResources.magicSparkParticles.sprite(GameRandom.globalRandom.nextInt(4), 0, 22)).lifeTime(500);
                    }
                    break block5;
                }
                if (!this.attackerMob.isClient() || !(this.getChargePercent() >= 2.0f) || this.charged2) break block7;
                this.charged2 = true;
                SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(1.0f).pitch(1.2f));
                SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(0.75f).pitch(1.0f));
                ParticleTypeSwitcher typeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.CRITICAL, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC});
                float anglePerParticle = 24.0f;
                for (int i = 0; i < 15; ++i) {
                    int angle = (int)((float)i * anglePerParticle + GameRandom.globalRandom.nextFloat() * anglePerParticle);
                    float dx = (float)Math.sin(Math.toRadians(angle)) * 50.0f;
                    float dy = (float)Math.cos(Math.toRadians(angle)) * 50.0f * 0.8f;
                    this.attackerMob.getLevel().entityManager.addParticle((Entity)this.attackerMob, typeSwitcher.next()).movesFriction(dx, dy, 0.8f).color(new Color(255, 225, 71)).heightMoves(0.0f, 10.0f).sizeFades(22, 44).sprite(GameResources.magicSparkParticles.sprite(GameRandom.globalRandom.nextInt(4), 0, 22)).lifeTime(500);
                }
                break block5;
            }
            if (!this.attackerMob.isClient() || !(this.getChargePercent() >= 1.0f) || this.charged) break block5;
            this.charged = true;
            SoundManager.playSound((GameSound)GameResources.cling, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(1.0f).pitch(0.7f));
            SoundManager.playSound((GameSound)GameResources.jingle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(0.5f).pitch(1.0f));
            ParticleTypeSwitcher typeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.CRITICAL, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC});
            float anglePerParticle = 36.0f;
            for (int i = 0; i < 10; ++i) {
                int angle = (int)((float)i * anglePerParticle + GameRandom.globalRandom.nextFloat() * anglePerParticle);
                float dx = (float)Math.sin(Math.toRadians(angle)) * 50.0f;
                float dy = (float)Math.cos(Math.toRadians(angle)) * 50.0f * 0.8f;
                this.attackerMob.getLevel().entityManager.addParticle((Entity)this.attackerMob, typeSwitcher.next()).movesFriction(dx, dy, 0.8f).color(new Color(116, 245, 253)).heightMoves(0.0f, 10.0f).sizeFades(22, 44).sprite(GameResources.magicSparkParticles.sprite(GameRandom.globalRandom.nextInt(4), 0, 22)).lifeTime(500);
            }
        }
    }

    public void onEndAttack(boolean bySelf) {
        if (this.getChargePercent() >= 1.0f) {
            Point2D.Float dir = GameMath.getAngleDir((float)this.currentAngle);
            int attackX = this.attackerMob.getX() + (int)(dir.x * 100.0f);
            int attackY = this.attackerMob.getY() + (int)(dir.y * 100.0f);
            InventoryItem attackItem = this.item.copy();
            attackItem.getGndData().setFloat("charge", this.getChargePercent());
            if (this.attackerMob.isClient() && this.charged3) {
                attackItem.getGndData().setBoolean("charged3", true);
            } else if (this.attackerMob.isClient() && this.charged2) {
                attackItem.getGndData().setBoolean("charged2", true);
            } else if (this.attackerMob.isClient() && this.charged) {
                attackItem.getGndData().setBoolean("charged", true);
            }
            GNDItemMap attackMap = this.attackerMob.showAttackAndSendAttacker(attackItem, attackX, attackY, 0, this.seed);
            this.toolItem.superOnAttack(this.attackerMob.getLevel(), attackX, attackY, this.attackerMob, this.attackerMob.getCurrentAttackHeight(), attackItem, this.slot, 0, this.seed, attackMap);
            for (ActiveBuff b : this.attackerMob.buffManager.getArrayBuffs()) {
                b.onItemAttacked(attackX, attackY, this.attackerMob, this.attackerMob.getCurrentAttackHeight(), attackItem, this.slot, 0, attackMap);
            }
        }
        this.attackerMob.doAndSendStopAttackAttacker(false);
    }
}

