/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.scripts;

import java.awt.geom.Point2D;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketPlayerStopAttack;
import necesse.engine.network.server.ServerClient;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.attackHandler.MouseAngleAttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameResources;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import rangedarsenal.items.weapons.NormalRevolver;

public class BurstRevolverAttackHandler
extends MouseAngleAttackHandler {
    private final InventoryItem item;
    private final NormalRevolver toolItem;
    private final int attackSeed;
    private int shotsRemaining = 6;
    private int shots;
    private int bullets;
    private long timeBuffer;
    private final GameRandom random = new GameRandom();
    private int timeBetweenReloads = 1700;
    private int timeBetweenBurstShots = 180;
    private int seed;

    public BurstRevolverAttackHandler(ItemAttackerMob attackerMob, ItemAttackSlot slot, InventoryItem item, NormalRevolver toolItem, int seed, int startTargetX, int startTargetY) {
        super(attackerMob, slot, 20, 1000.0f, startTargetX, startTargetY);
        this.attackSeed = seed;
        this.timeBuffer = this.timeBetweenReloads;
        this.item = item;
        this.seed = seed;
        this.toolItem = toolItem;
        this.timeBetweenReloads = 1700 - Math.round(toolItem.getUpgradeTier(item) * 100.0f);
        this.timeBetweenBurstShots = 180 - Math.round(toolItem.getUpgradeTier(item) * 8.0f);
    }

    public void onUpdate() {
        super.onUpdate();
        Point2D.Float dir = GameMath.getAngleDir((float)this.currentAngle);
        int attackX = this.attackerMob.getX() + (int)(dir.x * 100.0f);
        int attackY = this.attackerMob.getY() + (int)(dir.y * 100.0f);
        this.bullets = this.toolItem.getAvailableAmmoNR(this.attackerMob, this.bullets);
        if (this.toolItem.canAttack(this.attackerMob.getLevel(), attackX, attackY, this.attackerMob, this.item) == null) {
            float speedModifier;
            int seed = Item.getRandomAttackSeed((GameRandom)this.random.seeded((long)GameRandom.prime((int)(this.attackSeed * this.shots))));
            Packet attackContent = new Packet();
            this.attackerMob.showAttackAndSendAttacker(this.item, attackX, attackY, 0, seed);
            this.timeBuffer += (long)this.updateInterval;
            while (!((float)this.timeBuffer < (float)this.timeBetweenReloads * (speedModifier = this.getSpeedModifier()))) {
                seed = Item.getRandomAttackSeed((GameRandom)this.random.nextSeeded(GameRandom.prime((int)(this.attackSeed * this.shots))));
                ++this.shots;
                --this.shotsRemaining;
                --this.bullets;
                this.toolItem.getAvailableAmmoNR(this.attackerMob, this.bullets);
                InventoryItem attackItem = this.item.copy();
                GNDItemMap attackMap = this.attackerMob.showAttackAndSendAttacker(attackItem, attackX, attackY, 0, this.seed);
                this.toolItem.superOnAttack(this.attackerMob.getLevel(), attackX, attackY, this.attackerMob, this.attackerMob.getCurrentAttackHeight(), attackItem, this.slot, 0, this.seed, attackMap);
                if (this.attackerMob.isClient()) {
                    SoundManager.playSound((GameSound)GameResources.sniperrifle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.attackerMob).volume(0.65f).pitch(GameRandom.globalRandom.getFloatBetween(0.7f, 0.8f)));
                }
                if (this.shotsRemaining <= 0) {
                    this.shotsRemaining = 6;
                    this.timeBuffer = 0L;
                    break;
                }
                boolean get = true;
                this.timeBuffer = (int)((float)(this.timeBetweenReloads - this.timeBetweenBurstShots) * speedModifier);
            }
        }
    }

    private float getSpeedModifier() {
        return 1.0f / this.toolItem.getAttackSpeedModifier(this.item, this.attackerMob);
    }

    public void onEndAttack(boolean bySelf) {
        this.bullets = this.toolItem.getAvailableAmmoNR(this.attackerMob, this.bullets);
        if (this.bullets * -1 > 6) {
            while (this.bullets * -1 > 6) {
                this.bullets += 6;
            }
        }
        if (this.bullets * -1 != 6) {
            this.attackerMob.startItemCooldown((Item)this.toolItem, (int)(530.0f * (float)(this.bullets * -1) * this.getSpeedModifier()));
            this.attackerMob.stopAttack(false);
            if (this.attackerMob.isServer() && this.attackerMob.isPlayer) {
                ServerClient client = this.attackerMob.getFirstPlayerOwner().getServerClient();
                this.attackerMob.getLevel().getServer().network.sendToAllClientsExcept((Packet)new PacketPlayerStopAttack(client.slot), client);
            }
        } else {
            this.attackerMob.startItemCooldown((Item)this.toolItem, (int)((float)(3160L - this.timeBuffer) * this.getSpeedModifier()));
            this.attackerMob.stopAttack(false);
            if (this.attackerMob.isServer() && this.attackerMob.isPlayer) {
                ServerClient client = this.attackerMob.getFirstPlayerOwner().getServerClient();
                this.attackerMob.getLevel().getServer().network.sendToAllClientsExcept((Packet)new PacketPlayerStopAttack(client.slot), client);
            }
        }
    }
}

