/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.shells;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.entity.Entity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.light.GameLight;
import rangedarsenal.events.GrenadeLauncherProxyExplosionEvent;
import rangedarsenal.rangedarsenal;

public class GrenadeLauncherProxyProjectile
extends Projectile {
    private long spawnTime;
    public float staticAngle;
    int tickcount = 0;
    int tickcount2 = 0;
    boolean active;
    boolean landed;

    public GrenadeLauncherProxyProjectile() {
    }

    public GrenadeLauncherProxyProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        this();
        this.setLevel(owner.getLevel());
        this.applyData(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
        this.staticAngle = GrenadeLauncherProxyProjectile.getAngleToTarget((float)owner.x, (float)owner.y, (float)targetX, (float)targetY);
    }

    public void init() {
        super.init();
        this.setWidth(15.0f);
        this.height = 18.0f;
        this.heightBasedOnDistance = true;
        this.doesImpactDamage = true;
        this.trailOffset = 4.0f;
        this.canBounce = false;
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(124, 124, 124), 20.0f, 150, 1.0f);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y) - this.texture.getHeight() / 2;
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.staticAngle, this.texture.getWidth() / 2, this.texture.getHeight() / 2).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            this.addShadowDrawables(tileList, drawX, drawY, light, this.getAngle(), this.texture.getHeight() / 2);
        }
    }

    public void serverTick() {
        if (this.sendPositionUpdate && this.handlingClient == null) {
            this.sendServerUpdatePacket();
            this.sendPositionUpdate = false;
        }
        if (this.traveledDistance >= (float)this.distance) {
            ++this.tickcount;
        }
        if (this.tickcount >= 30) {
            if (this.tickcount > 339) {
                GrenadeLauncherProxyExplosionEvent event = new GrenadeLauncherProxyExplosionEvent(this.x, this.y, new GameDamage(200.0f + this.getDamage().damage * 6.0f, this.getDamage().armorPen + 200.0f, this.getDamage().baseCritChance + 0.0f), this.getOwner());
                this.getLevel().entityManager.addLevelEvent((LevelEvent)event);
                this.remove();
            }
            this.getLevel().entityManager.streamAreaMobsAndPlayersTileRange(this.getX(), this.getY(), 2).forEach(m -> {
                if ((m.isHostile || m.isPlayer || m.isCritter || m.canLevelInteract() && !m.isHuman) && m.x <= this.x + 33.0f && m.x >= this.x - 33.0f && m.y <= this.y + 33.0f && m.y >= this.y - 33.0f) {
                    GrenadeLauncherProxyExplosionEvent event = new GrenadeLauncherProxyExplosionEvent(this.x, this.y, new GameDamage(200.0f + this.getDamage().damage * 6.0f, this.getDamage().armorPen + 200.0f, this.getDamage().baseCritChance + 0.0f), this.getOwner());
                    this.getLevel().entityManager.addLevelEvent((LevelEvent)event);
                    this.remove();
                }
            });
        }
    }

    public void clientTick() {
        if (this.sendPositionUpdate) {
            if (this.isClient() && this.handlingClient == this.getLevel().getClient().getClient()) {
                this.sendClientUpdatePacket();
            }
            this.sendPositionUpdate = false;
        }
        if (this.givesLight && this.isClient()) {
            this.refreshParticleLight();
        }
        if (this.traveledDistance >= (float)this.distance) {
            if (!this.landed) {
                this.landed = true;
                this.texture = rangedarsenal.GlProxyArmingTex;
            }
            ++this.tickcount2;
        }
        if (this.tickcount2 >= 30 && !this.active) {
            this.active = true;
            this.texture = rangedarsenal.GlProxyArmedTex;
            SoundManager.playSound((GameSound)rangedarsenal.proxyarm, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(1.5f));
        }
    }

    protected void spawnDeathParticles() {
    }

    public float tickMovement(float delta) {
        float moveY;
        if (this.removed()) {
            return 0.0f;
        }
        float moveX = this.getMoveDist(this.dx * this.speed, delta);
        double totalDist = Math.sqrt(moveX * moveX + (moveY = this.getMoveDist(this.dy * this.speed, delta)) * moveY);
        if (Double.isNaN(totalDist) || Double.isInfinite(totalDist)) {
            totalDist = 0.0;
        }
        this.moveDist(totalDist);
        return (float)totalDist;
    }

    public void checkRemoved() {
        if (this.traveledDistance >= (float)this.distance && this.isServer() && this.dropItem) {
            this.dropItem();
        }
    }
}

