/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.shells;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rangedarsenal.events.GrenadeLauncherFireExplosionEvent;
import rangedarsenal.projectiles.fuel.NapalmBulletProjectile;

public class GrenadeLauncherFireProjectile
extends Projectile {
    private long spawnTime;
    public float staticAngle;

    public GrenadeLauncherFireProjectile() {
    }

    public GrenadeLauncherFireProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        this();
        this.setLevel(owner.getLevel());
        this.applyData(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
        this.staticAngle = GrenadeLauncherFireProjectile.getAngleToTarget((float)owner.x, (float)owner.y, (float)targetX, (float)targetY);
    }

    public void init() {
        super.init();
        this.setWidth(15.0f);
        this.height = 18.0f;
        this.heightBasedOnDistance = true;
        this.spawnTime = this.getWorldEntity().getTime();
        this.doesImpactDamage = false;
        this.trailOffset = 4.0f;
        this.canBounce = false;
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(0, 0, 0), 0.0f, 10, 1.0f);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y) - this.texture.getHeight() / 2;
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.staticAngle, this.texture.getWidth() / 2, this.texture.getHeight() / 2).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            this.addShadowDrawables(tileList, drawX, drawY, light, this.getAngle(), this.texture.getHeight() / 2);
        }
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        GameRandom random = GameRandom.globalRandom;
        if (this.isServer()) {
            GrenadeLauncherFireExplosionEvent event = new GrenadeLauncherFireExplosionEvent(x, y, new GameDamage(0.0f), this.getOwner());
            this.getLevel().entityManager.addLevelEvent((LevelEvent)event);
        }
        for (int i = 0; i <= 6; ++i) {
            NapalmBulletProjectile projectile = new NapalmBulletProjectile(x, y, x + (float)random.getIntBetween(-30, 30), y + (float)random.getIntBetween(-30, 30), random.getFloatBetween(300.0f, 500.0f), random.getIntBetween(10, 64), new GameDamage(20.0f, 100.0f), 0, this.getOwner());
            projectile.getUniqueID(random);
            this.getLevel().entityManager.projectiles.add((Entity)projectile);
            if (!this.getLevel().isServer()) continue;
            this.getLevel().getServer().network.sendToClientsWithEntityExcept((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile, ((PlayerMob)this.getOwner()).getServerClient());
        }
    }
}

