/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.modifiers;

import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.CaveSpiderWebEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffManager;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.level.maps.LevelObjectHit;

public class WebbedModifier
extends ProjectileModifier {
    private float resilienceGain;
    private boolean hasGained = false;

    public WebbedModifier() {
    }

    public WebbedModifier(float resilienceGain) {
        this.resilienceGain = resilienceGain;
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextFloat(this.resilienceGain);
        writer.putNextBoolean(this.hasGained);
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.resilienceGain = reader.getNextFloat();
        this.hasGained = reader.getNextBoolean();
    }

    public void initChildProjectile(Projectile projectile, float childStrength, int childCount) {
        super.initChildProjectile(projectile, childStrength, childCount);
        projectile.setModifier((ProjectileModifier)new WebbedModifier(this.resilienceGain / (float)childCount));
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        BuffManager attackerBM;
        super.doHitLogic(mob, object, x, y);
        if (this.projectile.isServer() && mob != null && (attackerBM = this.projectile.getAttackOwner().buffManager) != null) {
            float thresholdMod = ((Float)attackerBM.getModifier(BuffModifiers.CRIT_CHANCE)).floatValue() + ((Float)attackerBM.getModifier(BuffModifiers.RANGED_CRIT_CHANCE)).floatValue();
            float crystallizeMod = ((Float)attackerBM.getModifier(BuffModifiers.CRIT_DAMAGE)).floatValue() - 2.0f + ((Float)attackerBM.getModifier(BuffModifiers.RANGED_CRIT_DAMAGE)).floatValue();
            System.out.println(thresholdMod);
            System.out.println(crystallizeMod);
            int stackThreshold = (int)GameMath.limit((float)(5.0f - 5.0f * (thresholdMod + crystallizeMod)), (float)2.0f, (float)5.0f);
            System.out.println(stackThreshold);
            Buff crystallizeBuff = BuffRegistry.getBuff((String)"WebbedGunDebuff");
            ActiveBuff ab = new ActiveBuff(crystallizeBuff, mob, 10000, (Attacker)this.projectile.getAttackOwner());
            mob.buffManager.addBuff(ab, true);
            if (mob.buffManager.getBuff(crystallizeBuff).getStacks() >= stackThreshold) {
                this.getLevel().entityManager.addLevelEvent((LevelEvent)new CaveSpiderWebEvent(this.projectile.getOwner(), mob.getX(), mob.getY(), new GameRandom((long)this.projectile.getUniqueID())));
                mob.buffManager.removeBuff(crystallizeBuff, true);
                if (!mob.isBoss()) {
                    mob.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.SPIDER_WEB_SLOW, mob, 3.0f, (Attacker)this.projectile.getOwner()), true);
                }
            }
        }
        if (!this.hasGained) {
            Mob owner = this.projectile.getOwner();
            if (mob != null && owner != null && mob.canGiveResilience((Attacker)owner)) {
                owner.addResilience(this.resilienceGain);
                this.hasGained = true;
            }
        }
    }
}

