/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.fuel;

import java.awt.Color;
import java.awt.geom.Line2D;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.BulletProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.level.maps.LevelObjectHit;

public class NapalmBulletProjectile
extends BulletProjectile {
    public static GameTexture texture;
    int tickcount = 0;
    int tickcount2 = 0;
    int hitattempt = 0;
    int hitattempt2 = 0;

    public NapalmBulletProjectile() {
    }

    public NapalmBulletProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        super(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    public void init() {
        super.init();
        this.particleSpeedMod = 0.5f;
        this.piercing = 6;
        this.canBounce = true;
        this.bouncing = 1;
    }

    public Color getParticleColor() {
        return new Color(250, 70, 0);
    }

    protected Color getWallHitColor() {
        return new Color(200, 70, 0);
    }

    public Trail getTrail() {
        Trail trail = new Trail((Projectile)this, this.getLevel(), new Color(250, 70, 0), 25.0f, 150, this.getHeight());
        trail.sprite = new GameSprite(GameResources.chains, 7, 0, 32);
        return trail;
    }

    public void refreshParticleLight() {
        this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, 10.0f, this.lightSaturation);
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (this.isServer() && mob != null) {
            ActiveBuff ab = new ActiveBuff("FlamerSuperSlow", mob, 0.2f, (Attacker)this.getOwner());
            ActiveBuff ab2 = new ActiveBuff("NapalmDebuff", mob, 5.0f, (Attacker)this.getOwner());
            mob.addBuff(ab, true);
            mob.addBuff(ab2, true);
        }
    }

    public void serverTick() {
        if (this.sendPositionUpdate && this.handlingClient == null) {
            this.sendServerUpdatePacket();
            this.sendPositionUpdate = false;
        }
        ++this.tickcount;
        if (this.tickcount >= 5) {
            this.tickcount = 0;
            ++this.hitattempt;
            if (this.hitattempt > 26) {
                this.remove();
            }
            this.clearHits();
            this.checkHitCollision(new Line2D.Float(this.x, this.y, this.x + 3.0f, this.y + 3.0f));
        }
        if (this.bounced >= 1) {
            this.setDistance(32);
        }
    }

    public void clientTick() {
        float particleChance;
        if (this.sendPositionUpdate) {
            if (this.isClient() && this.handlingClient == this.getLevel().getClient().getClient()) {
                this.sendClientUpdatePacket();
            }
            this.sendPositionUpdate = false;
        }
        if (this.givesLight && this.isClient()) {
            this.refreshParticleLight();
        }
        if ((particleChance = this.getParticleChance()) > 0.0f && (particleChance >= 1.0f || GameRandom.globalRandom.nextFloat() <= particleChance)) {
            if (this.traveledDistance < (float)this.distance) {
                this.spawnSpinningParticle();
            } else {
                for (int i = 0; i < 2; ++i) {
                    this.getLevel().entityManager.addParticle(this.x + (float)GameRandom.globalRandom.getIntBetween(-10, 10), this.y + (float)GameRandom.globalRandom.getIntBetween(-10, 10), Particle.GType.IMPORTANT_COSMETIC).sprite(GameResources.puffParticles.sprite(GameRandom.globalRandom.getIntBetween(1, 2), 0, 12)).color(new Color(187, GameRandom.globalRandom.getIntBetween(60, 100), 0)).sizeFadesInAndOut(24, 34, 50, 15).movesConstant(this.dx / 2.0f, this.dy / 2.0f).lifeTime(500).height(2.0f);
                }
            }
        }
        ++this.tickcount2;
        if (this.tickcount2 >= 5) {
            this.tickcount2 = 0;
            ++this.hitattempt2;
            if (this.hitattempt2 > 26) {
                this.remove();
            }
            this.clearHits();
            this.checkHitCollision(new Line2D.Float(this.x, this.y, this.x + 3.0f, this.y + 3.0f));
        }
        if (this.bounced >= 1) {
            this.setDistance(32);
        }
    }

    protected void spawnDeathParticles() {
    }

    public float tickMovement(float delta) {
        float moveY;
        if (this.removed()) {
            return 0.0f;
        }
        float moveX = this.getMoveDist(this.dx * this.speed, delta);
        double totalDist = Math.sqrt(moveX * moveX + (moveY = this.getMoveDist(this.dy * this.speed, delta)) * moveY);
        if (Double.isNaN(totalDist) || Double.isInfinite(totalDist)) {
            totalDist = 0.0;
        }
        this.moveDist(totalDist);
        return (float)totalDist;
    }

    public void checkRemoved() {
        if (this.traveledDistance >= (float)this.distance) {
            this.doHitLogic(null, null, this.x, this.y);
            if (this.isServer() && this.dropItem) {
                this.dropItem();
            }
        }
    }

    public void playHitSound(float x, float y) {
    }
}

