/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.fuel;

import java.awt.Color;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.hostile.BloatedSpiderMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.BulletProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameSprite;
import necesse.level.maps.LevelObjectHit;
import rangedarsenal.events.SlimeSplosionEvent;

public class MoltenSlimeBulletProjectile
extends BulletProjectile {
    public MoltenSlimeBulletProjectile() {
    }

    public MoltenSlimeBulletProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        super(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    public void init() {
        super.init();
        this.particleSpeedMod = 0.5f;
        this.piercing = 5;
        this.canBounce = false;
    }

    public Color getParticleColor() {
        return new Color(60, 180, 70);
    }

    protected Color getWallHitColor() {
        return new Color(0, 180, 0);
    }

    public Trail getTrail() {
        Trail trail = new Trail((Projectile)this, this.getLevel(), new Color(60, 180, 0), 25.0f, 150, this.getHeight());
        trail.sprite = new GameSprite(GameResources.chains, 7, 0, 32);
        return trail;
    }

    public void refreshParticleLight() {
        this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, 130.0f, this.lightSaturation);
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (this.isServer() && mob != null) {
            SlimeSplosionEvent event;
            float duration = mob.buffManager.getBuffDurationLeftSeconds("SlimeSplosionDebuff");
            int buildup = 0;
            float pentup = 0.0f;
            if (duration >= 10.0f && mob.getHealthPercent() <= 0.15f && !mob.isBoss()) {
                buildup = Math.round(duration * 3.25f);
                pentup = duration * 5.5f;
                duration = 1.0f;
                mob.setHealth(1);
                mob.buffManager.removeBuff("SlimeSplosionDebuff", true);
                BloatedSpiderMob.explosionDamage = new GameDamage(pentup, 20.0f);
                event = new SlimeSplosionEvent(this.x, this.y, buildup, BloatedSpiderMob.explosionDamage, false, 0, null);
                this.getLevel().entityManager.addLevelEvent((LevelEvent)event);
            }
            if (duration >= 40.0f) {
                duration = 1.0f;
                BloatedSpiderMob.explosionDamage = new GameDamage(275.0f, 20.0f);
                mob.buffManager.removeBuff("SlimeSplosionDebuff", true);
                if (!mob.isBoss()) {
                    mob.setArmor(Math.round(mob.getArmorFlat() / 2));
                } else if (mob.getArmorFlat() >= 2) {
                    mob.setArmor(mob.getArmorFlat() - 2);
                }
                event = new SlimeSplosionEvent(this.x, this.y, 125, BloatedSpiderMob.explosionDamage, false, 0, null);
                this.getLevel().entityManager.addLevelEvent((LevelEvent)event);
            }
            ActiveBuff ab = new ActiveBuff("FlamerSuperSlow", mob, 0.2f, (Attacker)this.getOwner());
            ActiveBuff ab2 = new ActiveBuff("SlimeSplosionDebuff", mob, duration + 1.0f, (Attacker)this.getOwner());
            ActiveBuff ab3 = new ActiveBuff("MoltenSlimeDebuff", mob, 5.0f, (Attacker)this.getOwner());
            mob.addBuff(ab, true);
            mob.addBuff(ab2, true);
            mob.addBuff(ab3, true);
        }
    }

    public void playHitSound(float x, float y) {
    }
}

