/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.fuel;

import java.awt.Color;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.BulletProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameSprite;
import necesse.level.maps.LevelObjectHit;

public class CryoFlameBulletProjectile
extends BulletProjectile {
    public CryoFlameBulletProjectile() {
    }

    public CryoFlameBulletProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        super(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    public void init() {
        super.init();
        this.particleSpeedMod = 0.5f;
        this.piercing = 100;
        this.canBounce = false;
    }

    public Color getParticleColor() {
        return new Color(90, 150, 250);
    }

    protected Color getWallHitColor() {
        return new Color(0, 130, 250);
    }

    public Trail getTrail() {
        Trail trail = new Trail((Projectile)this, this.getLevel(), new Color(90, 150, 250), 7.0f, 30, this.getHeight());
        trail.sprite = new GameSprite(GameResources.chains, 7, 0, 32);
        return trail;
    }

    public void refreshParticleLight() {
        this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, 210.0f, this.lightSaturation);
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (this.isServer() && mob != null) {
            float duration = mob.buffManager.getBuffDurationLeftSeconds("CryoBuildupDebuff");
            if (duration >= 29.0f) {
                duration = 1.0f;
                ActiveBuff ab4 = new ActiveBuff("CryoFreezeDebuff", mob, 5.0f, (Attacker)this.getOwner());
                mob.buffManager.addBuff(ab4, true);
                mob.buffManager.removeBuff("CryoBuildupDebuff", true);
                SoundManager.playSound((GameSound)GameResources.shatter1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(0.5f, 0.6f)));
            }
            if (mob.buffManager.getBuffDurationLeftSeconds("CryoFreezeDebuff") > 0.0f) {
                mob.buffManager.removeBuff("CryoBuildupDebuff", true);
                duration = 1.0f;
            }
            ActiveBuff ab = new ActiveBuff("FlamerSlow", mob, 0.1f, (Attacker)this.getOwner());
            ActiveBuff ab2 = new ActiveBuff("CryoBuildupDebuff", mob, duration + 1.0f, (Attacker)this.getOwner());
            ActiveBuff ab3 = new ActiveBuff("FrostyDebuff", mob, 3.0f, (Attacker)this.getOwner());
            mob.addBuff(ab, true);
            mob.addBuff(ab2, true);
            mob.addBuff(ab3, true);
        }
    }

    public void playHitSound(float x, float y) {
    }
}

