/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.bullets;

import java.awt.Color;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.BulletProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameSprite;
import necesse.level.maps.LevelObjectHit;

public class NewBouncingBulletProjectile
extends BulletProjectile {
    int bounced = 0;
    Trail trail;
    int R = 56;
    int G = 53;
    int B = 172;
    int R2 = 56;
    int G2 = 53;
    int B2 = 172;

    public NewBouncingBulletProjectile() {
    }

    public NewBouncingBulletProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        super(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    public void init() {
        super.init();
        this.bouncing = 20;
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (mob == null) {
            int offset = new GameRandom((long)(this.getUniqueID() + this.bounced * 1337)).getIntBetween(-5, 5);
            this.setAngle(this.getAngle() + (float)offset);
            this.setDamage(new GameDamage(this.getDamage().damage * 1.06f, this.getDamage().armorPen * 1.0f, this.getDamage().baseCritChance + 0.01f));
            ++this.bounced;
            this.replaceTrail();
        }
    }

    public Trail getTrail() {
        this.R2 = this.inRange(this.R2 + this.bounced);
        this.G2 = this.inRange(this.G2 + this.bounced * 6);
        this.B2 = this.inRange(this.B2 + this.bounced * 3);
        this.trail = new Trail((Projectile)this, this.getLevel(), new Color(this.R2, this.G2, this.B2), 22.0f, 100, this.getHeight());
        this.trail.sprite = new GameSprite(GameResources.chains, 7, 0, 32);
        return this.trail;
    }

    public int inRange(int value) {
        if (value > 255) {
            value = 255;
        }
        return value;
    }

    protected Color getWallHitColor() {
        this.R = this.inRange(this.R + this.bounced);
        this.G = this.inRange(this.G + this.bounced * 6);
        this.B = this.inRange(this.B + this.bounced * 3);
        return new Color(this.R, this.G, this.B);
    }

    public void clientTick() {
        super.clientTick();
        this.replaceTrail();
    }

    public void refreshParticleLight() {
        this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, 220.0f, this.lightSaturation);
    }
}

