/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.bullets;

import java.awt.Color;
import necesse.engine.network.Packet;
import necesse.engine.network.client.ClientClient;
import necesse.engine.network.packet.PacketLevelEvent;
import necesse.engine.network.packet.PacketProjectileHit;
import necesse.engine.network.server.ServerClient;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.BulletProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameSprite;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rangedarsenal.events.LightningJumperEvent;

public class LightningBulletProjectile
extends BulletProjectile {
    float closest;
    int targetingX;
    int targetingY;
    int counter;
    int players;
    int hostiles;
    int critters;
    boolean done;
    int hostilescheck = 1;
    PlayerMob player = (PlayerMob)this.getOwner();

    public LightningBulletProjectile() {
    }

    public LightningBulletProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        super(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    public void init() {
        super.init();
    }

    public void onHit(Mob mob, LevelObjectHit object, float x, float y, boolean fromPacket, ServerClient packetSubmitter) {
        if (this.modifier == null || !this.modifier.onHit(mob, object, x, y, fromPacket, packetSubmitter)) {
            this.hit(mob, x, y, fromPacket, packetSubmitter);
            if (mob == null) {
                if (this.isClient()) {
                    this.spawnWallHitParticles(x, y);
                    this.playHitSound(x, y);
                }
                this.doHitLogic(mob, object, x, y);
                int bouncing = this.bouncing;
                Mob owner = this.getOwner();
                if (owner != null) {
                    bouncing += ((Integer)owner.buffManager.getModifier(BuffModifiers.PROJECTILE_BOUNCES)).intValue();
                }
                if (this.bounced >= bouncing || !this.canBounce) {
                    if (this.isBoomerang) {
                        this.returnToOwner();
                    } else {
                        if (this.dropItem && this.isServer()) {
                            this.dropItem();
                        }
                        this.remove();
                        this.sendRemovePacket = false;
                    }
                }
            } else {
                boolean canHit = this.checkHitCooldown(mob, !this.isServer() || packetSubmitter == null && this.handlingClient == null && (!this.clientHandlesHit || !mob.isPlayer) ? 0 : 100);
                if (canHit && (this.amountHit() <= this.piercing || this.returningToOwner)) {
                    boolean addHit = true;
                    SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).volume(0.6f).pitch(GameRandom.globalRandom.getFloatBetween(1.0f, 2.0f)));
                    SoundManager.playSound((GameSound)GameResources.fireworkCrack, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)mob).volume(4.0f).pitch(GameRandom.globalRandom.getFloatBetween(4.0f, 4.0f)));
                    if (mob.getLevel().entityManager.mobs.streamArea((float)mob.getX(), (float)mob.getY(), 1) != null) {
                        this.done = false;
                        this.counter = 0;
                        mob.getLevel().entityManager.mobs.streamArea((float)mob.getX(), (float)mob.getY(), 1).forEach(m -> {
                            if (m.x <= mob.x + 260.0f && m.x >= mob.x - 260.0f && m.y <= mob.y + 260.0f && m.y >= mob.y - 260.0f) {
                                ++this.counter;
                            }
                        });
                        this.players = 0;
                        mob.getLevel().entityManager.mobs.streamArea((float)mob.getX(), (float)mob.getY(), 1).forEach(m -> {
                            if (m.isPlayer && !m.isSameTeam((Mob)this.player) && this.player.getServerClient().pvpEnabled && m.x <= mob.x + 260.0f && m.x >= mob.x - 260.0f && m.y <= mob.y + 260.0f && m.y >= mob.y - 260.0f) {
                                ++this.players;
                            }
                        });
                        this.hostiles = 0;
                        mob.getLevel().entityManager.mobs.streamArea((float)mob.getX(), (float)mob.getY(), 1).forEach(m -> {
                            if (m.isHostile && m.x <= mob.x + 260.0f && m.x >= mob.x - 260.0f && m.y <= mob.y + 260.0f && m.y >= mob.y - 260.0f) {
                                ++this.hostiles;
                            }
                        });
                        this.critters = 0;
                        mob.getLevel().entityManager.mobs.streamArea((float)mob.getX(), (float)mob.getY(), 1).forEach(m -> {
                            if (m.isCritter && m.x <= mob.x + 260.0f && m.x >= mob.x - 260.0f && m.y <= mob.y + 260.0f && m.y >= mob.y - 260.0f) {
                                ++this.critters;
                            }
                        });
                        this.hostilescheck = 1;
                        mob.getLevel().entityManager.mobs.streamArea((float)mob.getX(), (float)mob.getY(), 1).forEach(m -> {
                            if (m.x <= mob.x + 260.0f && m.x >= mob.x - 260.0f && m.y <= mob.y + 260.0f && m.y >= mob.y - 260.0f) {
                                if (m != mob && m != this.getOwner()) {
                                    if (m.isPlayer) {
                                        if (!m.isSameTeam((Mob)this.player) && this.player.getServerClient().pvpEnabled) {
                                            float distancemob = m.getDistance(mob);
                                            if (this.closest == 0.0f) {
                                                this.closest = distancemob;
                                                this.targetingX = Math.round(m.x);
                                                this.targetingY = Math.round(m.y);
                                            } else if (distancemob < this.closest) {
                                                this.closest = distancemob;
                                                this.targetingX = Math.round(m.x);
                                                this.targetingY = Math.round(m.y);
                                            }
                                            this.done = true;
                                        }
                                    } else if (m.isHostile && this.players == 0) {
                                        float distancemob = m.getDistance(mob);
                                        if (this.closest == 0.0f) {
                                            this.closest = distancemob;
                                            this.targetingX = Math.round(m.x);
                                            this.targetingY = Math.round(m.y);
                                        } else if (distancemob < this.closest) {
                                            this.closest = distancemob;
                                            this.targetingX = Math.round(m.x);
                                            this.targetingY = Math.round(m.y);
                                        }
                                        this.done = true;
                                    } else if (m.isCritter && this.hostiles == 0 && this.players == 0) {
                                        float distancemob = m.getDistance(mob);
                                        if (this.closest == 0.0f) {
                                            this.closest = distancemob;
                                            this.targetingX = Math.round(m.x);
                                            this.targetingY = Math.round(m.y);
                                        } else if (distancemob < this.closest) {
                                            this.closest = distancemob;
                                            this.targetingX = Math.round(m.x);
                                            this.targetingY = Math.round(m.y);
                                        }
                                        this.done = true;
                                    } else if (m.canBeHit((Attacker)this.player) && this.hostiles == 0 && this.players == 0 && this.critters == 0) {
                                        float distancemob = m.getDistance(mob);
                                        if (this.closest == 0.0f) {
                                            this.closest = distancemob;
                                            this.targetingX = Math.round(m.x);
                                            this.targetingY = Math.round(m.y);
                                        } else if (distancemob < this.closest) {
                                            this.closest = distancemob;
                                            this.targetingX = Math.round(m.x);
                                            this.targetingY = Math.round(m.y);
                                        }
                                        this.done = true;
                                    }
                                }
                                if (this.counter <= this.hostilescheck && !this.done) {
                                    this.targetingX = mob.getX() + GameRandom.globalRandom.getIntBetween(-30, 30);
                                    this.targetingY = mob.getY() + GameRandom.globalRandom.getIntBetween(-30, 30);
                                }
                            }
                        });
                    } else {
                        this.targetingX = mob.getX() + GameRandom.globalRandom.getIntBetween(-30, 30);
                        this.targetingY = mob.getY() + GameRandom.globalRandom.getIntBetween(-30, 30);
                    }
                    for (int i = 0; i <= 2; ++i) {
                        LightningJumperEvent event = new LightningJumperEvent(this.player, this.getDamage(), 0.0f, mob.getX(), mob.getY(), this.targetingX, this.targetingY, GameRandom.globalRandom.getIntBetween(-50, 50), mob);
                        this.getOwner().getLevel().entityManager.addLevelEventHidden((LevelEvent)event);
                        if (!this.getLevel().isServer()) continue;
                        this.getLevel().getServer().network.sendToClientsWithEntityExcept((Packet)new PacketLevelEvent((LevelEvent)event), (RegionPositionGetter)event, this.player.getServerClient());
                    }
                    if (this.isServer()) {
                        boolean isClientProjectile;
                        boolean bl = isClientProjectile = this.handlingClient != null || this.clientHandlesHit && mob.isPlayer;
                        if (packetSubmitter == null && isClientProjectile) {
                            addHit = false;
                        } else {
                            if (this.doesImpactDamage) {
                                this.applyDamage(mob, x, y);
                            }
                            this.doHitLogic(mob, object, x, y);
                            if (packetSubmitter != null) {
                                this.getLevel().getServer().network.sendToClientsWithEntityExcept((Packet)new PacketProjectileHit((Projectile)this, x, y, mob), (RegionPositionGetter)this, packetSubmitter);
                            } else {
                                this.getLevel().getServer().network.sendToClientsWithEntity((Packet)new PacketProjectileHit((Projectile)this, x, y, mob), (RegionPositionGetter)this);
                            }
                        }
                    } else if (this.isClient()) {
                        if (!this.getClient().hasStrictServerAuthority()) {
                            ClientClient client = this.getClient().getClient();
                            if (!(this.clientHandlesHit && mob == client.playerMob || this.handlingClient == client)) {
                                this.doHitLogic(mob, object, x, y);
                            } else if (!fromPacket) {
                                this.getClient().network.sendPacket((Packet)new PacketProjectileHit((Projectile)this, x, y, mob));
                                this.startMobHitCooldown(mob);
                                this.doHitLogic(mob, object, x, y);
                            } else {
                                addHit = false;
                            }
                        } else {
                            this.doHitLogic(mob, object, x, y);
                        }
                    } else if (this.doesImpactDamage) {
                        this.applyDamage(mob, x, y);
                    }
                    if (addHit) {
                        this.addHit(mob);
                    }
                }
                if (this.amountHit() > this.piercing) {
                    if (this.isBoomerang) {
                        if (!this.returningToOwner) {
                            this.returnToOwner();
                        }
                    } else {
                        this.remove();
                    }
                }
            }
        }
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (this.isServer() && mob != null && !mob.buffManager.hasBuff("LightningDebuff")) {
            ActiveBuff ab = new ActiveBuff("LightningDebuff", mob, 3.0f, (Attacker)this.getOwner());
            mob.addBuff(ab, true);
        }
    }

    public Trail getTrail() {
        Trail trail = new Trail((Projectile)this, this.getLevel(), new Color(124, 92, 164), 25.0f, 150, this.getHeight());
        trail.sprite = new GameSprite(GameResources.chains, 7, 0, 32);
        return trail;
    }

    protected Color getWallHitColor() {
        return new Color(98, 43, 176);
    }

    public void refreshParticleLight() {
        this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, 0.0f, this.lightSaturation);
    }
}

