/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.bullets;

import java.awt.Color;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.projectile.bulletProjectile.BulletProjectile;
import necesse.gfx.gameFont.FontOptions;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.hudManager.HudDrawElement;
import necesse.level.maps.hudManager.floatText.DamageText;

public class LeachBulletProjectile
extends BulletProjectile {
    public LeachBulletProjectile() {
    }

    public LeachBulletProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        super(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    public void init() {
        super.init();
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (this.isServer() && mob != null && !this.getOwner().buffManager.hasBuff("HealDelayBuff")) {
            int armor;
            int damage = Math.round(this.getDamage().damage);
            int result = damage - Math.round((float)((armor = mob.getArmorFlat()) - 4) / 2.0f);
            if (result <= 0) {
                result = 1;
            }
            if ((result = Math.round((float)result / 3.0f)) <= 1) {
                result = 1;
            } else if (result >= 5) {
                result = 5;
            }
            this.getOwner().setHealth(this.getOwner().getHealth() + result);
            if (this.getOwner().getResilience() < (float)this.getOwner().getMaxResilience()) {
                this.getOwner().addResilience((float)result * 1.5f);
            }
            ActiveBuff ab = new ActiveBuff("HealDelayBuff", mob, 0.25f, (Attacker)this.getOwner());
            this.getOwner().addBuff(ab, true);
            this.getOwner().spawnDamageText(result, 16, false);
            this.getOwner().getLevel().hudManager.addElement((HudDrawElement)new DamageText(this.getOwner().getX(), this.getOwner().getY(), result, new FontOptions(16).color(new Color(0, 178, 0)), 35));
        }
    }
}

