/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.bullets;

import necesse.engine.network.Packet;
import necesse.engine.network.client.ClientClient;
import necesse.engine.network.packet.PacketProjectileHit;
import necesse.engine.network.server.ServerClient;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.BulletProjectile;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class BluntBulletProjectile
extends BulletProjectile {
    GameDamage ogdamage;

    public BluntBulletProjectile() {
    }

    public BluntBulletProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        super(x, y, targetX, targetY, speed, distance, damage, knockback, owner);
    }

    public void init() {
        super.init();
    }

    public void onHit(Mob mob, LevelObjectHit object, float x, float y, boolean fromPacket, ServerClient packetSubmitter) {
        GameDamage ogdamage = this.getDamage();
        if (this.modifier == null || !this.modifier.onHit(mob, object, x, y, fromPacket, packetSubmitter)) {
            this.hit(mob, x, y, fromPacket, packetSubmitter);
            if (mob == null) {
                if (this.isClient()) {
                    this.spawnWallHitParticles(x, y);
                    this.playHitSound(x, y);
                }
                this.doHitLogic(mob, object, x, y);
                int bouncing = this.bouncing;
                Mob owner = this.getOwner();
                if (owner != null) {
                    bouncing += ((Integer)owner.buffManager.getModifier(BuffModifiers.PROJECTILE_BOUNCES)).intValue();
                }
                if (this.bounced >= bouncing || !this.canBounce) {
                    if (this.isBoomerang) {
                        this.returnToOwner();
                    } else {
                        if (this.dropItem && this.isServer()) {
                            this.dropItem();
                        }
                        this.remove();
                        this.sendRemovePacket = false;
                    }
                }
            } else {
                boolean canHit = this.checkHitCooldown(mob, !this.isServer() || packetSubmitter == null && this.handlingClient == null && (!this.clientHandlesHit || !mob.isPlayer) ? 0 : 100);
                if (canHit && (this.amountHit() <= this.piercing || this.returningToOwner)) {
                    boolean addHit = true;
                    String mobname = mob.idData.getStringID().toString().toLowerCase();
                    if (mobname.contains("skeleton") || mobname.contains("crystal")) {
                        this.setDamage(ogdamage.modDamage(1.5f));
                    }
                    if (this.isServer()) {
                        boolean isClientProjectile;
                        boolean bl = isClientProjectile = this.handlingClient != null || this.clientHandlesHit && mob.isPlayer;
                        if (packetSubmitter == null && isClientProjectile) {
                            addHit = false;
                        } else {
                            if (this.doesImpactDamage) {
                                this.applyDamage(mob, x, y);
                            }
                            this.doHitLogic(mob, object, x, y);
                            if (packetSubmitter != null) {
                                this.getLevel().getServer().network.sendToClientsWithEntityExcept((Packet)new PacketProjectileHit((Projectile)this, x, y, mob), (RegionPositionGetter)this, packetSubmitter);
                            } else {
                                this.getLevel().getServer().network.sendToClientsWithEntity((Packet)new PacketProjectileHit((Projectile)this, x, y, mob), (RegionPositionGetter)this);
                            }
                        }
                    } else if (this.isClient()) {
                        if (!this.getClient().hasStrictServerAuthority()) {
                            ClientClient client = this.getClient().getClient();
                            if (!(this.clientHandlesHit && mob == client.playerMob || this.handlingClient == client)) {
                                this.doHitLogic(mob, object, x, y);
                            } else if (!fromPacket) {
                                this.getClient().network.sendPacket((Packet)new PacketProjectileHit((Projectile)this, x, y, mob));
                                this.startMobHitCooldown(mob);
                                this.doHitLogic(mob, object, x, y);
                            } else {
                                addHit = false;
                            }
                        } else {
                            this.doHitLogic(mob, object, x, y);
                        }
                    } else if (this.doesImpactDamage) {
                        this.applyDamage(mob, x, y);
                    }
                    this.setDamage(ogdamage);
                    if (addHit) {
                        this.addHit(mob);
                    }
                }
                if (this.amountHit() > this.piercing) {
                    if (this.isBoomerang) {
                        if (!this.returningToOwner) {
                            this.returnToOwner();
                        }
                    } else {
                        this.remove();
                    }
                }
            }
        }
    }
}

