/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.projectiles.bullets;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.Packet;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.CrystallizeShatterEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffManager;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.buffs.staticBuffs.Buff;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.particle.Particle;
import necesse.entity.particle.ProjectileHitStuckParticle;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.BulletProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.Drawable;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.gfx.gameTexture.GameSprite;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import rangedarsenal.projectiles.bullets.SapphireSplosionBulletProjectile;

public class AmethystBulletProjectile
extends BulletProjectile {
    PlayerMob player;
    float crystallizeMod;
    int stackThreshold;
    float thresholdMod;

    public AmethystBulletProjectile() {
    }

    public AmethystBulletProjectile(float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback, Mob owner) {
        this();
        this.setLevel(owner.getLevel());
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.setDistance(distance);
        this.setDamage(damage);
        this.knockback = knockback;
        this.setOwner(owner);
    }

    public void init() {
        super.init();
        this.particleSpeedMod = 0.03f;
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        BuffManager attackerBM;
        super.doHitLogic(mob, object, x, y);
        if (this.isServer() && mob != null && (attackerBM = this.getAttackOwner().buffManager) != null) {
            if (this.getOwner().isPlayer) {
                this.player = (PlayerMob)this.getOwner();
                this.thresholdMod = ((Float)attackerBM.getModifier(BuffModifiers.CRIT_CHANCE)).floatValue() + ((Float)attackerBM.getModifier(BuffModifiers.MELEE_CRIT_CHANCE)).floatValue();
                this.crystallizeMod = ((Float)attackerBM.getModifier(BuffModifiers.CRIT_DAMAGE)).floatValue() + ((Float)attackerBM.getModifier(BuffModifiers.MELEE_CRIT_DAMAGE)).floatValue();
                this.stackThreshold = this.player.getSelectedItem().item.getStringID().equalsIgnoreCase("deathripper") ? (int)GameMath.limit((float)(10.0f - 7.0f * this.thresholdMod), (float)5.0f, (float)6.0f) : (int)GameMath.limit((double)(10.0f - 7.0f * this.thresholdMod), (double)5.0, (double)Math.ceil(10.0 / Math.ceil((float)this.player.getSelectedItem().item.getAttackAnimTime(this.player.getSelectedItem(), (ItemAttackerMob)this.player) / 160.0f)));
            } else {
                this.thresholdMod = ((Float)attackerBM.getModifier(BuffModifiers.CRIT_CHANCE)).floatValue() + ((Float)attackerBM.getModifier(BuffModifiers.MELEE_CRIT_CHANCE)).floatValue();
                this.crystallizeMod = ((Float)attackerBM.getModifier(BuffModifiers.CRIT_DAMAGE)).floatValue() + ((Float)attackerBM.getModifier(BuffModifiers.MELEE_CRIT_DAMAGE)).floatValue();
                this.stackThreshold = (int)GameMath.limit((float)(10.0f - 7.0f * this.thresholdMod), (float)5.0f, (float)10.0f);
            }
            float crystallizeDamageMultiplier = GameMath.limit((float)(0.5f + (this.crystallizeMod - 2.0f) / 2.0f + this.thresholdMod / 2.0f), (float)0.5f, (float)2.0f);
            Buff crystallizeBuff = BuffRegistry.getBuff((String)"AmethystDebuff");
            ActiveBuff ab = new ActiveBuff(crystallizeBuff, mob, 10000, (Attacker)this.getAttackOwner());
            mob.buffManager.addBuff(ab, true);
            if (mob.buffManager.getBuff(crystallizeBuff).getStacks() >= this.stackThreshold) {
                this.getLevel().entityManager.addLevelEvent((LevelEvent)new CrystallizeShatterEvent(mob, CrystallizeShatterEvent.ParticleType.AMETHYST));
                mob.buffManager.removeBuff(crystallizeBuff, true);
                int shotCount = Math.round(GameMath.limit((float)(this.getDamage().damage / 15.0f), (float)1.0f, (float)15.0f));
                for (int i = 0; i <= shotCount; ++i) {
                    GameRandom random = GameRandom.globalRandom;
                    int shootangle = GameRandom.globalRandom.getIntBetween(0, 7);
                    if (shootangle == 0) {
                        this.targetX = mob.getX() + GameRandom.globalRandom.getIntBetween(-5, 5);
                        this.targetY = mob.getY() + GameRandom.globalRandom.getIntBetween(5, 15);
                    } else if (shootangle == 1) {
                        this.targetX = mob.getX() + GameRandom.globalRandom.getIntBetween(5, 15);
                        this.targetY = mob.getY() + GameRandom.globalRandom.getIntBetween(5, 15);
                    } else if (shootangle == 2) {
                        this.targetX = mob.getX() + GameRandom.globalRandom.getIntBetween(5, 15);
                        this.targetY = mob.getY() + GameRandom.globalRandom.getIntBetween(-5, 5);
                    } else if (shootangle == 3) {
                        this.targetX = mob.getX() + GameRandom.globalRandom.getIntBetween(5, 15);
                        this.targetY = mob.getY() + GameRandom.globalRandom.getIntBetween(-5, -15);
                    } else if (shootangle == 4) {
                        this.targetX = mob.getX() + GameRandom.globalRandom.getIntBetween(-5, 5);
                        this.targetY = mob.getY() + GameRandom.globalRandom.getIntBetween(-5, -15);
                    } else if (shootangle == 5) {
                        this.targetX = mob.getX() + GameRandom.globalRandom.getIntBetween(-15, -5);
                        this.targetY = mob.getY() + GameRandom.globalRandom.getIntBetween(-15, -5);
                    } else if (shootangle == 6) {
                        this.targetX = mob.getX() + GameRandom.globalRandom.getIntBetween(-15, -5);
                        this.targetY = mob.getY() + GameRandom.globalRandom.getIntBetween(-5, 5);
                    } else if (shootangle == 7) {
                        this.targetX = mob.getX() + GameRandom.globalRandom.getIntBetween(-15, -5);
                        this.targetY = mob.getY() + GameRandom.globalRandom.getIntBetween(5, 15);
                    }
                    SapphireSplosionBulletProjectile projectile = new SapphireSplosionBulletProjectile(mob.x, mob.y, this.targetX, this.targetY, 470.0f, 97, this.getDamage().modDamage(2.0f), 0, mob, this.getOwner());
                    projectile.getUniqueID(random);
                    this.getLevel().entityManager.projectiles.add((Entity)projectile);
                    if (!this.getLevel().isServer()) continue;
                    if (this.getOwner().isPlayer) {
                        this.getLevel().getServer().network.sendToClientsWithEntityExcept((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile, ((PlayerMob)this.getOwner()).getServerClient());
                        continue;
                    }
                    this.getLevel().getServer().network.sendToAllClients((Packet)new PacketSpawnProjectile((Projectile)projectile));
                }
            }
        }
        if (this.isClient() && this.bounced == this.getTotalBouncing() && (this.amountHit() >= this.piercing || object != null)) {
            this.getLevel().entityManager.addParticle((Particle)new ProjectileHitStuckParticle(mob, (Projectile)this, x, y, GameRandom.globalRandom.getIntBetween(10, 20), 5000L){

                public void addDrawables(Mob target, float x, float y, float angle, List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
                    int fadeTime;
                    GameLight light = level.getLightLevel((Entity)this);
                    int drawX = camera.getDrawX(x) - 2;
                    int drawY = camera.getDrawY(y - AmethystBulletProjectile.this.height) - 2;
                    float alpha = 1.0f;
                    long lifeCycleTime = this.getLifeCycleTime();
                    if (lifeCycleTime >= this.lifeTime - (long)(fadeTime = 1000)) {
                        alpha = Math.abs((float)(lifeCycleTime - (this.lifeTime - (long)fadeTime)) / (float)fadeTime - 1.0f);
                    }
                    TextureDrawOptionsEnd options = AmethystBulletProjectile.this.texture.initDraw().light(light).rotate(AmethystBulletProjectile.this.getAngle(), 2, 2).alpha(alpha).pos(drawX, drawY);
                    EntityDrawable drawable = new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                        final /* synthetic */ TextureDrawOptions val$options;
                        {
                            this.val$options = textureDrawOptions;
                            super(arg0);
                        }

                        public void draw(TickManager tickManager) {
                            this.val$options.draw();
                        }
                    };
                    if (target != null) {
                        topList.add((Drawable)drawable);
                    } else {
                        list.add((LevelSortedDrawable)drawable);
                    }
                }
            }, Particle.GType.IMPORTANT_COSMETIC);
        }
    }

    public void onMaxMoveTick() {
        if (this.isClient()) {
            this.spawnSpinningParticle();
        }
    }

    public Trail getTrail() {
        Trail trail = new Trail((Projectile)this, this.getLevel(), new Color(172, 118, 192), 22.0f, 100, this.height);
        trail.sprite = new GameSprite(GameResources.chains, 7, 0, 32);
        return trail;
    }

    protected Color getWallHitColor() {
        return new Color(159, 13, 199);
    }

    public void refreshParticleLight() {
        this.getLevel().lightManager.refreshParticleLightFloat(this.x, this.y, this.getWallHitColor(), this.lightSaturation);
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y);
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.getAngle(), this.texture.getWidth() / 2, 0).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            this.addShadowDrawables(tileList, drawX, drawY, light, this.getAngle(), 0);
        }
    }

    public void playHitSound(float x, float y) {
        SoundManager.playSound((GameSound)GameResources.crystalHit1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this).volume(2.0f).pitch(GameRandom.globalRandom.getFloatBetween(0.9f, 1.1f)));
    }
}

