/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.bulletProjectile.HandGunBulletProjectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.ShardCannonProjectileToolItem;
import necesse.level.maps.Level;
import rangedarsenal.projectiles.modifiers.CrystalizeModifier;

public class ShardCannonRework
extends ShardCannonProjectileToolItem
implements ItemInteractAction {
    public ShardCannonRework() {
        this.attackDamage.setBaseValue(25.0f).setUpgradedValue(1.0f, 28.0f).setUpgradedValue(10.0f, 112.0f);
        this.velocity.setBaseValue(300);
        this.attackRange.setBaseValue(2000);
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        return tooltips;
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        float distance = GameMath.diamondDistance((float)attackerMob.x, (float)attackerMob.y, (float)x, (float)y);
        float t = 20.0f / distance;
        float projectileX = (1.0f - t) * attackerMob.x + t * (float)x;
        float projectileY = (1.0f - t) * attackerMob.y + t * (float)y;
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        Projectile projectile = !attackerMob.isPlayer ? this.getProjectile(item, (BulletItem)ItemRegistry.getItem((String)"crystalbullet"), attackerMob.x, attackerMob.y, x, y, this.getAttackRange(item), attackerMob) : this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, this.getAttackRange(item), attackerMob);
        projectile.setModifier((ProjectileModifier)new CrystalizeModifier(this.getResilienceGain(item)));
        projectile.dropItem = dropItem;
        projectile.getUniqueID(random);
        attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist, spreadRandom.getFloatOffset(0.0f, 3.0f));
    }

    public void playFireSound(AttackAnimMob mob) {
    }

    public Projectile getNormalProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage toolItemDamage, int knockback, ItemAttackerMob attackerMob) {
        return new HandGunBulletProjectile(x, y, targetX, targetY, velocity, range, toolItemDamage, knockback, (Mob)attackerMob);
    }

    public Projectile getProjectile(InventoryItem item, BulletItem bulletItem, float x, float y, float targetX, float targetY, int range, ItemAttackerMob attackerMob) {
        float velocity = bulletItem.modVelocity((float)this.getProjectileVelocity(item, (Mob)attackerMob));
        range = bulletItem.modRange(range);
        GameDamage damage = bulletItem.modDamage(this.getAttackDamage(item));
        int knockback = bulletItem.modKnockback(this.getKnockback(item, (Attacker)attackerMob));
        return bulletItem.overrideProjectile() ? bulletItem.getProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, (Mob)attackerMob) : this.getNormalProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
    }
}

