/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import rangedarsenal.scripts.SapphireRevolverAttackHandlerRework;

public class SapphireRevolverRework
extends GunProjectileToolItem {
    public SapphireRevolverRework() {
        super(NORMAL_AMMO_TYPES, 500, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.RARE;
        this.attackAnimTime.setBaseValue(400);
        this.attackDamage.setBaseValue(25.0f).setUpgradedValue(1.0f, 160.0f);
        this.attackXOffset = 8;
        this.attackYOffset = 12;
        this.attackRange.setBaseValue(2000);
        this.velocity.setBaseValue(2000);
        this.addGlobalIngredient(new String[]{"bulletuser"});
    }

    public float getAttackMovementMod(InventoryItem item) {
        if (this.getUpgradeTier(item) < 1.0f) {
            return 0.6f;
        }
        return Math.min(0.6f + this.getUpgradeTier(item) / 100.0f * 2.0f, 0.7f);
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"sapphirerevolvertip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"sapphirerevolvertip2"));
        return tooltips;
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        attackerMob.startAttackHandler((AttackHandler)new SapphireRevolverAttackHandlerRework(attackerMob, slot, item, this, seed, x, y, this.getUpgradeTier(item)));
        return item;
    }

    public InventoryItem superOnAttack(Level level, int attackX, int attackY, ItemAttackerMob attackerMob, int currentAttackHeight, InventoryItem attackItem, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        return super.onAttack(level, attackX, attackY, attackerMob, currentAttackHeight, attackItem, slot, animAttack, seed, mapContent);
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        float charge = item.getGndData().getFloat("charge", 1.0f);
        float distance = GameMath.diamondDistance((float)attackerMob.x, (float)attackerMob.y, (float)x, (float)y);
        float t = 30.0f / distance;
        float projectileX = (1.0f - t) * attackerMob.x + t * (float)x;
        float projectileY = (1.0f - t) * attackerMob.y + t * (float)y;
        GameRandom random = new GameRandom((long)seed);
        Projectile projectile = !attackerMob.isPlayer ? this.getProjectile(item, (BulletItem)ItemRegistry.getItem((String)"Ruby_Bullet"), attackerMob.x, attackerMob.y, x, y, 2000, attackerMob) : this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, 2000, attackerMob);
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        projectile.dropItem = dropItem;
        projectile.getUniqueID(random);
        projectile.piercing = attackerMob.buffManager.hasBuff(BuffRegistry.getBuff((String)"soldiercapsetbonus")) ? projectile.piercing + (int)Math.floor(charge) - 2 : projectile.piercing + (int)Math.floor(charge) - 1;
        projectile.setDamage(new GameDamage(projectile.getDamage().damage, projectile.getDamage().armorPen + (float)((int)Math.floor(charge * 3.0f)) - 3.0f, projectile.getDamage().baseCritChance + ((float)(Math.floor(charge) / 11.0) - 0.09f)));
        attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
    }

    public void playFireSound(AttackAnimMob mob) {
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (attackerMob.isClient() && item.getGndData().getBoolean("charged3")) {
            SoundManager.playSound((GameSound)GameResources.shatter1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(1.3f, 1.7f)));
            SoundManager.playSound((GameSound)GameResources.sniperrifle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.1f).pitch(GameRandom.globalRandom.getFloatBetween(0.4f, 0.6f)));
            SoundManager.playSound((GameSound)GameResources.laserBlast1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(2.2f).pitch(GameRandom.globalRandom.getFloatBetween(0.95f, 1.25f)));
        } else if (attackerMob.isClient() && item.getGndData().getBoolean("charged2")) {
            SoundManager.playSound((GameSound)GameResources.shatter1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(1.3f, 1.7f)));
            SoundManager.playSound((GameSound)GameResources.sniperrifle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(0.4f, 0.6f)));
            SoundManager.playSound((GameSound)GameResources.laserBlast1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.5f).pitch(GameRandom.globalRandom.getFloatBetween(0.75f, 0.9f)));
        } else if (attackerMob.isClient() && item.getGndData().getBoolean("charged")) {
            SoundManager.playSound((GameSound)GameResources.shatter1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(1.3f, 1.7f)));
            SoundManager.playSound((GameSound)GameResources.sniperrifle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.5f).pitch(GameRandom.globalRandom.getFloatBetween(0.4f, 0.6f)));
            SoundManager.playSound((GameSound)GameResources.laserBlast1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.0f).pitch(GameRandom.globalRandom.getFloatBetween(0.45f, 0.65f)));
        }
    }
}

