/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import java.awt.Point;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundSettings;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;
import rangedarsenal.rangedarsenal;

public class ProduceCannonMega
extends GunProjectileToolItem {
    public ProduceCannonMega() {
        super(rangedarsenal.FOOD_AMMO_TYPES, 1200, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.LEGENDARY;
        this.attackAnimTime.setBaseValue(397).setUpgradedValue(1.0f, 331);
        this.attackDamage.setBaseValue(60.0f).setUpgradedValue(1.0f, 91.0f);
        this.attackXOffset = 17;
        this.attackYOffset = 18;
        this.attackRange.setBaseValue(641).setUpgradedValue(1.0f, 700);
        this.velocity.setBaseValue(300).setUpgradedValue(1.0f, 321);
        this.knockback.setBaseValue(0);
        this.canBeUsedForRaids = false;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = true;
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"FoodgunTip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"FoodgunTip2"));
    }

    protected SoundSettings getAttackSound() {
        return null;
    }

    protected void playAttackSound(Mob source) {
        SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)source).volume(0.79f).pitch(1.71f));
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        Item bullet;
        int bulletID = mapContent.getShortUnsigned("bulletID", 65535);
        if (bulletID != 65535 && (bullet = ItemRegistry.getItem((int)bulletID)) != null) {
            GameRandom random = new GameRandom((long)(seed + 5));
            boolean consumeAmmo = true;
            if (attackerMob.isPlayer) {
                if (!consumeAmmo || attackerMob.getFirstPlayerOwner().getInv().main.removeItems(level, attackerMob.getFirstPlayerOwner(), bullet, 1, "bulletammo") >= 1) {
                    if (ItemRegistry.itemExists((String)(bullet.idData.getStringID().replaceFirst(Character.toString(bullet.idData.getStringID().charAt(0)), Character.toString(bullet.idData.getStringID().charAt(0)).toUpperCase()) + "_Food_Bullet"))) {
                        bullet = ItemRegistry.getItem((String)(bullet.idData.getStringID().replaceFirst(Character.toString(bullet.idData.getStringID().charAt(0)), Character.toString(bullet.idData.getStringID().charAt(0)).toUpperCase()) + "_Food_Bullet"));
                        this.fireProjectiles(level, x, y, attackerMob, item, seed, (BulletItem)bullet, true, mapContent);
                    } else {
                        bullet = ItemRegistry.getItem((String)"Apple_Food_Bullet");
                        this.fireProjectiles(level, x, y, attackerMob, item, seed, (BulletItem)bullet, false, mapContent);
                    }
                }
            } else {
                bullet = ItemRegistry.getItem((String)"Pumpkin_Food_Bullet");
                this.fireProjectiles(level, x, y, attackerMob, item, seed, (BulletItem)bullet, false, mapContent);
            }
        }
        return item;
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        if (bullet == ItemRegistry.getItem((String)"Coffee_Food_Bullet")) {
            for (int i = 0; i <= 2; ++i) {
                Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
                projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
                projectile.dropItem = dropItem;
                projectile.getUniqueID(new GameRandom((long)seed));
                projectile.setDamage(this.getDamage(item).modFinalMultiplier(0.38f));
                projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 11.0f);
                attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
            }
        } else if (bullet == ItemRegistry.getItem((String)"Rice_Food_Bullet")) {
            for (int i = 0; i <= 7; ++i) {
                Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
                projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
                projectile.dropItem = dropItem;
                projectile.getUniqueID(new GameRandom((long)seed));
                projectile.setDamage(this.getDamage(item).modFinalMultiplier(0.18f));
                projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 21.0f);
                attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
            }
        } else if (bullet == ItemRegistry.getItem((String)"Wheat_Food_Bullet")) {
            for (int i = 0; i <= 5; ++i) {
                Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
                projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
                projectile.dropItem = dropItem;
                projectile.getUniqueID(new GameRandom((long)seed));
                projectile.setDamage(this.getDamage(item).modFinalMultiplier(0.24f));
                projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 19.0f);
                attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
            }
        } else {
            Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            projectile.dropItem = dropItem;
            projectile.getUniqueID(new GameRandom((long)seed));
            projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 1.0f);
            attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
        }
    }

    public Projectile getProjectile(InventoryItem item, BulletItem bulletItem, float x, float y, float targetX, float targetY, int range, ItemAttackerMob attackerMob) {
        float velocity = bulletItem.modVelocity((float)this.getVelocity(item, (Mob)attackerMob));
        range = bulletItem.modRange(range);
        GameDamage damage = bulletItem.modDamage(this.getDamage(item));
        int knockback = bulletItem.modKnockback(this.getKnockback(item, (Attacker)attackerMob));
        return bulletItem.getProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, (Mob)attackerMob);
    }
}

