/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.SoundSettings;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;
import rangedarsenal.scripts.BurstRevolverAttackHandler;

public class NormalRevolver
extends GunProjectileToolItem {
    public NormalRevolver() {
        super(NORMAL_AMMO_TYPES, 1000, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.UNCOMMON;
        this.attackAnimTime.setBaseValue(180).setUpgradedValue(1.0f, 172).setUpgradedValue(2.0f, 164).setUpgradedValue(3.0f, 156).setUpgradedValue(4.0f, 148);
        this.attackDamage.setBaseValue(42.0f).setUpgradedValue(1.0f, 55.0f).setUpgradedValue(2.0f, 60.0f).setUpgradedValue(3.0f, 65.0f).setUpgradedValue(4.0f, 70.0f);
        this.attackXOffset = 12;
        this.attackYOffset = 14;
        this.attackRange.setBaseValue(800);
        this.velocity.setBaseValue(1000);
        this.knockback.setBaseValue(70);
        this.resilienceGain.setBaseValue(0.2f);
        this.addGlobalIngredient(new String[]{"bulletuser"});
        this.canBeUsedForRaids = true;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = true;
    }

    protected void addExtraGunTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        super.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"RevolverTip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"RevolverTip2"));
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        super.addAmmoTooltips(tooltips, item);
    }

    protected SoundSettings getAttackSound() {
        return null;
    }

    public int getAvailableAmmoNR(ItemAttackerMob attackerMob, int bullets) {
        return bullets;
    }

    public InventoryItem superOnAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        return super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        attackerMob.startAttackHandler((AttackHandler)new BurstRevolverAttackHandler(attackerMob, slot, item, this, seed, x, y));
        return item;
    }
}

