/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import java.awt.Point;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundSettings;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;

public class LightMachinegun
extends GunProjectileToolItem {
    public LightMachinegun() {
        super(NORMAL_AMMO_TYPES, 1600, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.COMMON;
        this.attackAnimTime.setBaseValue(100);
        this.attackDamage.setBaseValue(9.0f).setUpgradedValue(1.0f, 15.0f).setUpgradedValue(10.0f, 73.0f);
        this.attackXOffset = 14;
        this.attackYOffset = 10;
        this.moveDist = 50;
        this.attackRange.setBaseValue(500);
        this.velocity.setBaseValue(400);
        this.knockback.setBaseValue(0).setUpgradedValue(1.0f, 10);
        this.resilienceGain.setBaseValue(0.2f);
        this.ammoConsumeChance = 0.75f;
        this.addGlobalIngredient(new String[]{"bulletuser"});
        this.canBeUsedForRaids = true;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = true;
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        super.addAmmoTooltips(tooltips, item);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"LightMachinegunTip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"LightMachinegunTip2"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"LightMachinegunTip3"));
    }

    protected SoundSettings getAttackSound() {
        return null;
    }

    protected void playAttackSound(Mob source) {
        SoundManager.playSound((GameSound)GameResources.handgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)source).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(1.5f, 1.7f)));
    }

    public float getAttackMovementMod(InventoryItem item) {
        return 0.7f;
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        projectile.dropItem = dropItem;
        projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * (12.0f - this.getUpgradeTier(item) / 1.6f));
        projectile.getUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
    }
}

