/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import necesse.engine.GameLog;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemGameDamage;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundSettings;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;

public class LeverActionRifle
extends GunProjectileToolItem
implements ItemInteractAction {
    public LeverActionRifle() {
        super(NORMAL_AMMO_TYPES, 500, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.NORMAL;
        this.attackAnimTime.setBaseValue(1200).setUpgradedValue(1.0f, 1100).setUpgradedValue(10.0f, 700);
        this.attackDamage.setBaseValue(34.0f).setUpgradedValue(1.0f, 115.0f);
        this.attackXOffset = 22;
        this.attackYOffset = 12;
        this.velocity.setBaseValue(700).setUpgradedValue(1.0f, 750);
        this.attackRange.setBaseValue(1000).setUpgradedValue(1.0f, 1100).setUpgradedValue(5.0f, 1500);
        this.knockback.setBaseValue(50);
        this.resilienceGain.setBaseValue(0.4f).setUpgradedValue(1.0f, 0.401f).setUpgradedValue(4.0f, 0.405f);
        this.addGlobalIngredient(new String[]{"bulletuser"});
        this.canBeUsedForRaids = true;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = true;
    }

    public GameDamage getFlatAttackDamage(InventoryItem item) {
        GNDItemMap gndData = item.getGndData();
        if (gndData.hasKey("damage")) {
            GNDItem gndItem = gndData.getItem("damage");
            if (gndItem instanceof GNDItemGameDamage) {
                return ((GNDItemGameDamage)gndItem).damage;
            }
            if (gndItem instanceof GNDItem.GNDPrimitive) {
                float damage = ((GNDItem.GNDPrimitive)gndItem).getFloat();
                return new GameDamage(this.getDamageType(item), damage);
            }
        }
        if (this.getUpgradeTier(item) > 0.0f) {
            return new GameDamage(this.getDamageType(item), this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue(), 0.0f, Math.min(0.15f + this.getUpgradeTier(item) / 100.0f, 0.25f));
        }
        return new GameDamage(this.getDamageType(item), this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue(), 0.0f, 0.15f);
    }

    protected SoundSettings getAttackSound() {
        return null;
    }

    protected void playAttackSound(Mob source) {
        SoundManager.playSound((GameSound)GameResources.sniperrifle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)source).pitch(1.21f).volume(0.9f));
    }

    protected void addExtraGunTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        super.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"Lever_Action_RifleSecondaryTip"), 400);
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return !attackerMob.buffManager.hasBuff("LeverActionRifleCooldownDebuff");
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        ++projectile.piercing;
        projectile.dropItem = dropItem;
        projectile.getUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        if (attackerMob.isPlayer) {
            Item bulletcheck = attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo");
            if (bulletcheck != null) {
                ActiveBuff ab = new ActiveBuff("LeverActionRifleCooldownDebuff", (Mob)attackerMob, 2.0f, (Attacker)attackerMob);
                attackerMob.buffManager.addBuff(ab, true);
                Item bullet = attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo");
                int range = this.getAttackRange(item);
                Projectile projectile = this.getProjectile(item, (BulletItem)bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
                projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
                projectile.dropItem = true;
                projectile.getUniqueID(new GameRandom((long)seed));
                attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
                if (attackerMob.buffManager.hasBuff(BuffRegistry.getBuff((String)"soldiercapsetbonus"))) {
                    GameLog.debug.println("wack");
                    projectile.piercing = 1;
                } else {
                    GameLog.debug.println("wack2");
                    projectile.piercing += 3;
                }
                projectile.setDamage(new GameDamage(this.getDamageType(item), this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue(), 0.0f, 0.3f + this.getUpgradeTier(item) * 0.04f));
                attackerMob.getFirstPlayerOwner().getInv().removeItems(attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo"), 1, true, true, true, true, "bulletammo");
                SoundManager.playSound((GameSound)GameResources.sniperrifle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.1f).pitch(GameRandom.globalRandom.getFloatBetween(0.85f, 0.9f)));
                SoundManager.playSound((GameSound)GameResources.sniperrifle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.5f).pitch(GameRandom.globalRandom.getFloatBetween(0.4f, 0.45f)));
                SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.25f).pitch(1.0f));
            }
        } else {
            ActiveBuff ab = new ActiveBuff("LeverActionRifleCooldownDebuff", (Mob)attackerMob, 2.0f, (Attacker)attackerMob);
            attackerMob.buffManager.addBuff(ab, true);
            int range = this.getAttackRange(item);
            Projectile projectile = this.getProjectile(item, (BulletItem)ItemRegistry.getItem((String)"Standard_Bullet"), attackerMob.x, attackerMob.y, x, y, range, attackerMob);
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            projectile.dropItem = true;
            projectile.getUniqueID(new GameRandom((long)seed));
            attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
            projectile.piercing = 4;
            projectile.setDamage(new GameDamage(this.getDamageType(item), this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue(), 0.0f, 1.0f));
            SoundManager.playSound((GameSound)GameResources.sniperrifle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.1f).pitch(GameRandom.globalRandom.getFloatBetween(0.85f, 0.9f)));
            SoundManager.playSound((GameSound)GameResources.sniperrifle, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.5f).pitch(GameRandom.globalRandom.getFloatBetween(0.4f, 0.45f)));
            SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.25f).pitch(1.0f));
        }
        return item;
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        return perspective.buffManager.getBuffDurationLeftSeconds("LeverActionRifleCooldownDebuff") / 5.0f;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }
}

