/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import java.awt.Point;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundSettings;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.itemAttacker.AmmoConsumed;
import necesse.entity.mobs.itemAttacker.AmmoUserMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;
import rangedarsenal.rangedarsenal;

public class GrenadeLauncher
extends GunProjectileToolItem {
    public GrenadeLauncher() {
        super(rangedarsenal.SHELL_AMMO_TYPES, 2000, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.RARE;
        this.attackAnimTime.setBaseValue(1500).setUpgradedValue(1.0f, 1400).setUpgradedValue(2.0f, 1300).setUpgradedValue(3.0f, 1200).setUpgradedValue(4.0f, 1000).setUpgradedValue(5.0f, 975);
        this.attackDamage.setBaseValue(100.0f).setUpgradedValue(1.0f, 150.0f).setUpgradedValue(5.0f, 185.0f);
        this.attackXOffset = 12;
        this.attackYOffset = 14;
        this.attackRange.setBaseValue(350);
        this.velocity.setBaseValue(110).setUpgradedValue(1.0f, 120).setUpgradedValue(2.0f, 130).setUpgradedValue(3.0f, 140).setUpgradedValue(5.0f, 150);
        this.knockback.setBaseValue(0);
        this.controlledRange = false;
        this.canBeUsedForRaids = false;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = true;
    }

    protected SoundSettings getAttackSound() {
        return null;
    }

    protected void playAttackSound(Mob source) {
        SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)source).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(1.15f, 1.15f)));
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"GrenadeLauncherTip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"GrenadeLauncherTip2"));
    }

    public float getAttackMovementMod(InventoryItem item) {
        return 0.6f;
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        Item bullet;
        int bulletID = mapContent.getShortUnsigned("bulletID", 65535);
        if (bulletID != 65535 && (bullet = ItemRegistry.getItem((int)bulletID)) != null && bullet.type == Item.Type.BULLET) {
            boolean dropItem;
            boolean shouldFire;
            boolean consumeAmmo;
            GameRandom random = new GameRandom((long)(seed + 5));
            float ammoConsumeChance = ((BulletItem)bullet).getAmmoConsumeChance() * this.getAmmoConsumeChance(attackerMob, item);
            boolean bl = consumeAmmo = ammoConsumeChance >= 1.0f || ammoConsumeChance > 0.0f && random.getChance(ammoConsumeChance);
            if (!consumeAmmo) {
                shouldFire = true;
                dropItem = false;
            } else if (attackerMob instanceof AmmoUserMob) {
                AmmoConsumed consumed = ((AmmoUserMob)attackerMob).removeAmmo(bullet, 1, "bulletammo");
                shouldFire = consumed.amount >= 1;
                dropItem = random.getChance(consumed.dropChance);
            } else {
                shouldFire = true;
                dropItem = false;
            }
            if (shouldFire) {
                if (bullet.idData.getStringID().equalsIgnoreCase("Grenade_Launcher_Proxy_Shell")) {
                    this.controlledRange = true;
                    this.fireProjectiles(level, x, y, attackerMob, item, seed, (BulletItem)bullet, dropItem, mapContent);
                } else {
                    this.controlledRange = false;
                    this.fireProjectiles(level, x, y, attackerMob, item, seed, (BulletItem)bullet, dropItem, mapContent);
                }
            }
        }
        return item;
    }

    public Projectile getProjectile(InventoryItem item, BulletItem bulletItem, float x, float y, float targetX, float targetY, int range, ItemAttackerMob attackerMob) {
        float velocity = bulletItem.modVelocity((float)this.getProjectileVelocity(item, (Mob)attackerMob));
        range = bulletItem.modRange(range);
        GameDamage damage = bulletItem.modDamage(this.getAttackDamage(item));
        damage = bulletItem.idData.getStringID().equalsIgnoreCase("GrenadeLauncherProxyShell") ? new GameDamage(this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue() / 4.0f, (float)bulletItem.armorPen, bulletItem.critChance) : new GameDamage((float)bulletItem.damage + this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue(), (float)bulletItem.armorPen, bulletItem.critChance + this.getCritChance(item, (Attacker)attackerMob));
        int knockback = bulletItem.modKnockback(this.getKnockback(item, (Attacker)attackerMob));
        return bulletItem.overrideProjectile() ? bulletItem.getProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, (Mob)attackerMob) : this.getNormalProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, attackerMob);
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        Projectile projectile = attackerMob.isPlayer ? this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob) : this.getProjectile(item, (BulletItem)ItemRegistry.getItem((String)"Grenade_Launcher_Shell"), attackerMob.x, attackerMob.y, x, y, range, attackerMob);
        projectile.setDamage(new GameDamage(projectile.getDamage().damage + this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue(), projectile.getDamage().armorPen, projectile.getDamage().baseCritChance));
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        projectile.dropItem = dropItem;
        projectile.getUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
    }
}

