/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import java.awt.Point;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.SoundSettings;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import rangedarsenal.rangedarsenal;

public class Flamethrower
extends GunProjectileToolItem {
    public Flamethrower() {
        super(rangedarsenal.FLAME_AMMO_TYPES, 1000, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.RARE;
        this.attackAnimTime.setBaseValue(40).setUpgradedValue(1.0f, 35);
        this.attackDamage.setBaseValue(7.0f).setUpgradedValue(1.0f, 9.0f).setUpgradedValue(5.0f, 14.0f);
        this.attackXOffset = 12;
        this.attackYOffset = 14;
        this.attackRange.setBaseValue(230).setUpgradedValue(1.0f, 320);
        this.velocity.setBaseValue(68).setUpgradedValue(1.0f, 97);
        this.knockback.setBaseValue(0);
        this.keyWords.add("flamethrower");
        this.resilienceGain.setBaseValue(0.15f);
        this.ammoConsumeChance = 0.75f;
        this.controlledRange = false;
        this.controlledMinRange = 5;
        this.canBeUsedForRaids = false;
    }

    protected SoundSettings getAttackSound() {
        return new SoundSettings(GameResources.firespell1).volume(0.12f).pitchVariance(GameRandom.globalRandom.getFloatBetween(0.03f, 0.05f));
    }

    public float getAttackMovementMod(InventoryItem item) {
        return 0.25f;
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"FlamethrowerTip"));
    }

    protected float getAmmoConsumeChance(ItemAttackerMob attackerMob, InventoryItem item) {
        float playerMod = attackerMob == null ? 1.0f : ((Float)attackerMob.buffManager.getModifier(BuffModifiers.BULLET_USAGE)).floatValue();
        return GameMath.limit((float)((this.ammoConsumeChance - this.getUpgradeTier(item) * 5.0f / 100.0f) * playerMod), (float)0.5f, (float)0.75f);
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        if (this.getUpgradeTier(item) == 1.0f) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"FlamethrowerTipammo", (String)"ammouse", (Object)30));
        } else if (this.getUpgradeTier(item) == 2.0f) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"FlamethrowerTipammo", (String)"ammouse", (Object)35));
        } else if (this.getUpgradeTier(item) == 3.0f) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"FlamethrowerTipammo", (String)"ammouse", (Object)40));
        } else if (this.getUpgradeTier(item) == 4.0f) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"FlamethrowerTipammo", (String)"ammouse", (Object)45));
        } else if (this.getUpgradeTier(item) >= 5.0f) {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"FlamethrowerTipammo", (String)"ammouse", (Object)50));
        } else {
            tooltips.add(Localization.translate((String)"itemtooltip", (String)"FlamethrowerTipammo", (String)"ammouse", (Object)25));
        }
        return tooltips;
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        this.controlledRange = bullet.idData.getStringID().equalsIgnoreCase("Napalm");
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
        projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 6.5f);
        projectile.dropItem = dropItem;
        projectile.getUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
    }
}

