/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.ItemRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundSettings;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.bulletItem.BulletItem;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;
import rangedarsenal.scripts.BurstFireAttackHandlerRA;

public class DoubleBarrel
extends GunProjectileToolItem
implements ItemInteractAction {
    public DoubleBarrel() {
        super(NORMAL_AMMO_TYPES, 1200, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.COMMON;
        this.attackAnimTime.setBaseValue(910);
        this.attackDamage.setBaseValue(26.0f).setUpgradedValue(1.0f, 34.0f);
        this.attackXOffset = 20;
        this.attackYOffset = 10;
        this.attackRange.setBaseValue(655);
        this.velocity.setBaseValue(350);
        this.knockback.setBaseValue(50).setUpgradedValue(1.0f, 65).setUpgradedValue(5.0f, 115);
        this.resilienceGain.setBaseValue(0.1f);
        this.addGlobalIngredient(new String[]{"bulletuser"});
        this.canBeUsedForRaids = false;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = true;
    }

    protected SoundSettings getAttackSound() {
        return null;
    }

    public void playFireSound(AttackAnimMob mob) {
    }

    protected void addExtraGunTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        super.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"DoubleBarrelPrimaryTip"), 400);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"DoubleBarrelSecondaryTip"), 400);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"Shotguntier", (String)"pellets", (Object)Math.round(this.getUpgradeTier(item) / 2.0f + 4.0f)));
    }

    protected void addAmmoTooltips(ListGameTooltips tooltips, InventoryItem item) {
        super.addAmmoTooltips(tooltips, item);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        attackerMob.startAttackHandler((AttackHandler)new BurstFireAttackHandlerRA(attackerMob, slot, item, this, seed, x, y, 820, 140, 2));
        return item;
    }

    public int getAvailableAmmoBurst(ItemAttackerMob attackerMob, int bullets) {
        return bullets;
    }

    public InventoryItem superOnAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        return super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
    }

    public float getAttackMovementMod(InventoryItem item) {
        return 0.6f;
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, BulletItem bullet, boolean dropItem, GNDItemMap mapContent) {
        int range;
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = new GameRandom((long)(seed + 10));
        if (this.controlledRange) {
            Point newTarget = this.controlledRangePosition(new GameRandom((long)(seed + 10)), (Mob)attackerMob, x, y, item, this.controlledMinRange, this.controlledInaccuracy);
            x = newTarget.x;
            y = newTarget.y;
            range = (int)attackerMob.getDistance((float)x, (float)y);
        } else {
            range = this.getAttackRange(item);
        }
        int i = 0;
        while ((float)i <= 3.0f + this.getUpgradeTier(item) / 2.0f) {
            Projectile projectile = this.getProjectile(item, bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
            projectile.setDamage(this.getDamage(item).modFinalMultiplier(0.8f));
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            projectile.dropItem = dropItem;
            projectile.getUniqueID(new GameRandom((long)seed));
            attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
            projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 22.0f);
            ++i;
        }
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return !attackerMob.buffManager.hasBuff("DoubleBarrelCooldownDebuff");
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        if (attackerMob.isPlayer) {
            Item bulletcheck = attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo");
            if (bulletcheck != null) {
                ActiveBuff ab = new ActiveBuff("DoubleBarrelCooldownDebuff", (Mob)attackerMob, 2.0f, (Attacker)attackerMob);
                attackerMob.buffManager.addBuff(ab, true);
                Item bullet = attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo");
                int range = this.getAttackRange(item);
                GameRandom random = new GameRandom((long)seed);
                GameRandom spreadRandom = new GameRandom((long)(seed + 10));
                int i = 0;
                while ((float)i <= 7.0f + this.getUpgradeTier(item) / 2.0f) {
                    Projectile projectile = this.getProjectile(item, (BulletItem)bullet, attackerMob.x, attackerMob.y, x, y, range, attackerMob);
                    projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 28.0f);
                    projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
                    projectile.dropItem = true;
                    projectile.getUniqueID(new GameRandom((long)seed));
                    attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
                    ++i;
                }
                attackerMob.getFirstPlayerOwner().getInv().removeItems(attackerMob.getFirstPlayerOwner().getInv().main.getFirstItem(level, attackerMob.getFirstPlayerOwner(), this.ammoItems(), "bulletammo"), 1, true, true, true, true, "bulletammo");
                SoundManager.playSound((GameSound)GameResources.shotgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.1f).pitch(GameRandom.globalRandom.getFloatBetween(0.8f, 0.85f)));
                SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.75f).pitch(1.0f));
            }
        } else {
            ActiveBuff ab = new ActiveBuff("DoubleBarrelCooldownDebuff", (Mob)attackerMob, 2.0f, (Attacker)attackerMob);
            attackerMob.buffManager.addBuff(ab, true);
            int range = this.getAttackRange(item);
            GameRandom random = new GameRandom((long)seed);
            GameRandom spreadRandom = new GameRandom((long)(seed + 10));
            int i = 0;
            while ((float)i <= 7.0f + this.getUpgradeTier(item) / 2.0f) {
                Projectile projectile = this.getProjectile(item, (BulletItem)ItemRegistry.getItem((String)"Flame_Bullet"), attackerMob.x, attackerMob.y, x, y, range, attackerMob);
                projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 28.0f);
                projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
                projectile.dropItem = true;
                projectile.getUniqueID(new GameRandom((long)seed));
                attackerMob.addAndSendAttackerProjectile(projectile, this.moveDist);
                ++i;
            }
            SoundManager.playSound((GameSound)GameResources.shotgun, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(1.1f).pitch(GameRandom.globalRandom.getFloatBetween(0.8f, 0.85f)));
            SoundManager.playSound((GameSound)GameResources.explosionLight, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.75f).pitch(1.0f));
        }
        return item;
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        return perspective.buffManager.getBuffDurationLeftSeconds("DoubleBarrelCooldownDebuff") / 2.0f;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }
}

