/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.weapons;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.SoundSettings;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.toolItem.projectileToolItem.gunProjectileToolItem.GunProjectileToolItem;
import necesse.inventory.lootTable.presets.GunWeaponsLootTable;
import necesse.level.maps.Level;
import necesse.level.maps.incursion.IncursionData;

public class CryoBlasterRework
extends GunProjectileToolItem
implements ItemInteractAction {
    public CryoBlasterRework() {
        super(NORMAL_AMMO_TYPES, 1500, GunWeaponsLootTable.gunWeapons);
        this.rarity = Item.Rarity.EPIC;
        this.attackAnimTime.setBaseValue(300);
        this.attackDamage.setBaseValue(55.0f).setUpgradedValue(1.0f, 75.83335f);
        this.attackXOffset = 10;
        this.attackYOffset = 12;
        this.attackRange.setBaseValue(1000);
        this.velocity.setBaseValue(550);
        this.addGlobalIngredient(new String[]{"bulletuser"});
        this.canBeUsedForRaids = true;
        this.maxRaidTier = IncursionData.ITEM_TIER_UPGRADE_CAP;
        this.raidTicketsModifier = 0.5f;
        this.useForRaidsOnlyIfObtained = true;
    }

    protected SoundSettings getAttackSound() {
        return new SoundSettings(GameResources.jinglehit);
    }

    public float getAttackMovementMod(InventoryItem item) {
        return 0.5f + this.getUpgradeTier(item) / 4.0f / 10.0f;
    }

    protected void addExtraGunTooltips(ListGameTooltips tooltips, InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        super.addExtraGunTooltips(tooltips, item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"CryoBlasterSecondaryTip"), 400);
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return !attackerMob.buffManager.hasBuff("CryoBlasterCooldownDebuff");
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        ActiveBuff ab = new ActiveBuff("CryoBlasterCooldownDebuff", (Mob)attackerMob, 7.0f - this.getUpgradeTier(item), (Attacker)attackerMob);
        attackerMob.buffManager.addBuff(ab, true);
        for (int i = 0; i <= 7; ++i) {
            attackerMob.getLevel().entityManager.addParticle(attackerMob.x, attackerMob.y, Particle.GType.IMPORTANT_COSMETIC).colorRandom(230.0f, 0.65f, 1.0f, 0.0f, 0.15f, 0.0f).height(16.0f).lifeTime(2000).movesFriction(GameRandom.globalRandom.getFloatBetween(0.0f, 40.0f), GameRandom.globalRandom.getFloatBetween(0.0f, 40.0f), GameRandom.globalRandom.getFloatBetween(0.27f, 0.83f));
            attackerMob.getLevel().entityManager.addParticle(attackerMob.x, attackerMob.y, Particle.GType.IMPORTANT_COSMETIC).colorRandom(230.0f, 0.65f, 1.0f, 0.0f, 0.15f, 0.0f).height(16.0f).lifeTime(2000).movesFriction(GameRandom.globalRandom.getFloatBetween(0.0f, -40.0f), GameRandom.globalRandom.getFloatBetween(0.0f, -40.0f), GameRandom.globalRandom.getFloatBetween(0.27f, 0.83f));
            attackerMob.getLevel().entityManager.addParticle(attackerMob.x, attackerMob.y, Particle.GType.IMPORTANT_COSMETIC).colorRandom(230.0f, 0.65f, 1.0f, 0.0f, 0.15f, 0.0f).height(16.0f).lifeTime(2000).movesFriction(GameRandom.globalRandom.getFloatBetween(0.0f, 40.0f), GameRandom.globalRandom.getFloatBetween(0.0f, -40.0f), GameRandom.globalRandom.getFloatBetween(0.27f, 0.83f));
            attackerMob.getLevel().entityManager.addParticle(attackerMob.x, attackerMob.y, Particle.GType.IMPORTANT_COSMETIC).colorRandom(230.0f, 0.65f, 1.0f, 0.0f, 0.15f, 0.0f).height(16.0f).lifeTime(2000).movesFriction(GameRandom.globalRandom.getFloatBetween(0.0f, -40.0f), GameRandom.globalRandom.getFloatBetween(0.0f, 40.0f), GameRandom.globalRandom.getFloatBetween(0.27f, 0.83f));
        }
        if (attackerMob.getLevel().entityManager.mobs.streamArea((float)attackerMob.getX(), (float)attackerMob.getY(), 2) != null) {
            attackerMob.getLevel().entityManager.mobs.streamArea((float)attackerMob.getX(), (float)attackerMob.getY(), 2).forEach(m -> {
                if (m != attackerMob && !m.isSameTeam((Mob)attackerMob) && m.isHostile && !m.isBoss() && m.x <= attackerMob.x + (100.0f + this.getUpgradeTier(item) * 12.0f) && m.x >= attackerMob.x - (100.0f + this.getUpgradeTier(item) * 12.0f) && m.y <= attackerMob.y + (100.0f + this.getUpgradeTier(item) * 12.0f) && m.y >= attackerMob.y - (100.0f + this.getUpgradeTier(item) * 12.0f)) {
                    ActiveBuff mb = new ActiveBuff("frozenenemy", (Mob)attackerMob, 3.0f + this.getUpgradeTier(item) / 2.0f, (Attacker)attackerMob);
                    m.buffManager.addBuff(mb, true);
                }
            });
        }
        SoundManager.playSound((GameSound)GameResources.swoosh, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.52f).pitch(3.0f));
        SoundManager.playSound((GameSound)GameResources.shatter2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.6f).pitch(2.0f));
        SoundManager.playSound((GameSound)GameResources.magicbolt1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.85f).pitch(3.0f));
        return item;
    }

    public float getItemCooldownPercent(InventoryItem item, PlayerMob perspective) {
        return perspective.buffManager.getBuffDurationLeftSeconds("CryoBlasterCooldownDebuff") / 7.0f;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }
}

