/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.misc;

import java.awt.Color;
import java.io.FileNotFoundException;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.GameResources;
import necesse.gfx.gameFont.FontManager;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.Inventory;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.miscItem.PouchItem;
import necesse.level.maps.Level;
import necesse.level.maps.hudManager.HudDrawElement;
import rangedarsenal.scripts.ItemPickupTextSpecial;

public class AmmoPouchPlus
extends PouchItem {
    int heldwep;
    int count;
    int slot;
    int slot2;
    int startslot;
    int startslot2;
    int endslot2;
    public String report;
    String activebullet;
    String newbullet;

    public AmmoPouchPlus() {
        this.rarity = Item.Rarity.UNCOMMON;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"ammopouchtip1"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"AmmoPouchPlusTip1"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"AmmoPouchPlusTipPrimary"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"rclickinvopentip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"storedammo", (String)"items", (Object)this.getStoredItemAmounts(item)));
        return tooltips;
    }

    public boolean isValidPouchItem(InventoryItem item) {
        return this.isValidRequestType(item.item.type);
    }

    public boolean isValidRequestItem(Item item) {
        if (item == null) {
            return !this.isValidRequestType(null);
        }
        return this.isValidRequestType(item.type);
    }

    public boolean isValidRequestType(Item.Type type) {
        return type == Item.Type.ARROW || type == Item.Type.BULLET;
    }

    public int getInternalInventorySize() {
        return 10;
    }

    public int CurrentWeapon(PlayerMob perspective) {
        this.heldwep = perspective.getSelectedItem() != null ? (perspective.getSelectedItem().item.getClass().getSuperclass().toString().contains("bow") ? 1 : (perspective.getSelectedItem().item.getClass().getSuperclass().toString().contains("gun") ? (perspective.getSelectedItem().item.getClass().toString().toLowerCase().contains("handcannon") ? 3 : (perspective.getSelectedItem().item.getClass().toString().toLowerCase().contains("flamethrower") ? 4 : (perspective.getSelectedItem().item.getClass().toString().toLowerCase().contains("launcher") ? 5 : (perspective.getSelectedItem().item.getClass().toString().toLowerCase().contains("seed") ? 6 : 2)))) : 0)) : 0;
        return this.heldwep;
    }

    public void drawIcon(InventoryItem item, PlayerMob perspective, int x, int y, int size, String ctype) {
        Color col = this.getDrawColor(item, perspective);
        if (this.heldwep != 0 && this.getStoredItemAmounts(item) != 0) {
            Inventory internalInventory = this.getInternalInventory(item);
            for (int i = 0; i < internalInventory.getSize(); ++i) {
                if (internalInventory.isSlotClear(i)) continue;
                this.slot2 = i;
            }
            if (this.getInternalInventory(item).getItem(this.slot2) != null) {
                if (!(this.getInternalInventory((InventoryItem)item).getItem((int)this.slot2).item.type != Item.Type.BULLET || this.getInternalInventory((InventoryItem)item).getItem((int)this.slot2).item.getClass().toString().toLowerCase().contains("ball") || this.getInternalInventory((InventoryItem)item).getItem((int)this.slot2).item.getClass().toString().toLowerCase().contains("fuel") || this.getInternalInventory((InventoryItem)item).getItem((int)this.slot2).item.getClass().toString().toLowerCase().contains("shells") || this.heldwep != 2)) {
                    this.getItemSpriteBackground(item, perspective).initDraw().color(255.0f, 255.0f, 255.0f, 0.38f).size(35).draw(x, y);
                    this.getItemSprite(item, perspective).initDraw().color(col).size(size).draw(x, y - 4);
                } else {
                    this.getItemSpriteBackground(item, perspective).initDraw().color(255.0f, 255.0f, 255.0f, 0.38f).size(35).draw(x, y);
                    this.getItemSprite(item, perspective).initDraw().color(col).size(size).draw(x, y);
                }
            }
        } else {
            this.getItemSprite(item, perspective).initDraw().color(col).size(size).draw(x, y);
        }
    }

    public GameSprite getItemSprite(InventoryItem item, PlayerMob perspective) {
        if (this.slot < 0) {
            if (this.fullTexture != null) {
                Inventory internalInventory = this.getInternalInventory(item);
                for (int i = 0; i < internalInventory.getSize(); ++i) {
                    if (internalInventory.isSlotClear(i)) continue;
                    return new GameSprite(this.fullTexture, 32);
                }
            }
        } else {
            if (this.getInternalInventory(item).getItem(this.slot) != null) {
                try {
                    return new GameSprite(GameTexture.fromFileRaw((String)("items/" + this.getInternalInventory((InventoryItem)item).getItem((int)this.slot).item.getStringID())));
                }
                catch (FileNotFoundException e) {
                    try {
                        return new GameSprite(GameTexture.fromFileRaw((String)("items/" + this.getStringID())));
                    }
                    catch (FileNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
            try {
                return new GameSprite(GameTexture.fromFileRaw((String)("items/" + this.getStringID())));
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        return super.getItemSprite(item, perspective);
    }

    public GameSprite getItemSpriteBackground(InventoryItem item, PlayerMob perspective) {
        if (this.fullTexture != null) {
            Inventory internalInventory = this.getInternalInventory(item);
            for (int i = 0; i < internalInventory.getSize(); ++i) {
                if (internalInventory.isSlotClear(i)) continue;
                return new GameSprite(this.fullTexture);
            }
        }
        return super.getItemSprite(item, perspective);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(InventoryItem item, PlayerMob perspective, int x, int y, boolean inInventory) {
        int total;
        Inventory internalInventory = this.getInternalInventory(item);
        if (!this.drawStoredItems) return;
        this.heldwep = this.CurrentWeapon(perspective);
        if (this.heldwep == 0) {
            this.slot = -2;
        } else {
            for (int i = 0; i < internalInventory.getSize(); ++i) {
                if (internalInventory.getAmount(i) > 0) {
                    if (internalInventory.getItem((int)i).item.type == Item.Type.ARROW && this.heldwep == 1) {
                        this.slot = i;
                        this.report = "arrow";
                        break;
                    }
                    if (internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("ball") && this.heldwep == 3) {
                        this.slot = i;
                        this.report = "cannon";
                        break;
                    }
                    if (internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("fuel") && this.heldwep == 4) {
                        this.slot = i;
                        this.report = "flame";
                        break;
                    }
                    if (internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("shells") && this.heldwep == 5) {
                        this.slot = i;
                        this.report = "launcher";
                        break;
                    }
                    if (!(internalInventory.getItem((int)i).item.type != Item.Type.BULLET || internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("ball") || internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("fuel") || internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("shells") || this.heldwep != 2)) {
                        this.slot = i;
                        this.report = "bullet";
                        break;
                    }
                    this.slot = -1;
                }
                if (internalInventory.getAmount(i) >= 0 || internalInventory.getSize() != i) continue;
                this.slot = -1;
                break;
            }
        }
        this.drawIcon(item, perspective, x, y, 32, this.report);
        if (internalInventory.getAmount(this.slot) > 0) {
            total = 0;
        } else {
            if (this.slot == -1) {
                if (this.heldwep == 0) return;
                this.count = 0;
                String amountString = String.valueOf(this.count);
                int width = FontManager.bit.getWidthCeil(amountString, tipFontOptions);
                FontManager.bit.drawString((float)(x + 32 - width), (float)(y + 20), amountString, tipFontOptions);
                return;
            }
            this.count = this.getStoredItemAmounts(item);
            if (this.count > 9999) {
                this.count = 9999;
            }
            String amountString = String.valueOf(this.count);
            int width = FontManager.bit.getWidthCeil(amountString, tipFontOptions);
            FontManager.bit.drawString((float)(x + 32 - width), (float)(y + 20), amountString, tipFontOptions);
            return;
        }
        for (int i = 0; i < internalInventory.getSize(); ++i) {
            if (internalInventory.getAmount(i) <= 0) continue;
            if (internalInventory.getItem(i).getItemDisplayName().equals(internalInventory.getItem(this.slot).getItemDisplayName())) {
                total += internalInventory.getAmount(i);
                continue;
            }
            if (!(internalInventory.getItem((int)i).item.type != Item.Type.ARROW && this.heldwep == 1 || !internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("ball") && this.heldwep == 3 || !internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("fuel") && this.heldwep == 4 || !internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("shells") && this.heldwep == 5) && (internalInventory.getItem((int)i).item.type != Item.Type.ARROW && !internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("ball") && !internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("fuel") && !internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("shells") || this.heldwep != 2)) break;
        }
        if (total > 9999) {
            total = 9999;
        }
        if (this.heldwep != 0) {
            String amountString = String.valueOf(total);
            int width = FontManager.bit.getWidthCeil(amountString, tipFontOptions);
            FontManager.bit.drawString((float)(x + 32 - width), (float)(y + 20), amountString, tipFontOptions);
            return;
        }
        this.count = this.getStoredItemAmounts(item);
        if (this.count > 9999) {
            this.count = 9999;
        }
        String amountString = String.valueOf(this.count);
        int width = FontManager.bit.getWidthCeil(amountString, tipFontOptions);
        FontManager.bit.drawString((float)(x + 32 - width), (float)(y + 20), amountString, tipFontOptions);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        int i;
        Inventory internalInventory = this.getInternalInventory(item);
        if (internalInventory.getItem(0) == null) {
            // empty if block
        }
        boolean used = false;
        for (i = 0; i < internalInventory.getSize(); ++i) {
            if (internalInventory.getAmount(i) > 0) {
                this.activebullet = internalInventory.getItem((int)i).item.idData.getStringID();
                break;
            }
            ++this.startslot;
        }
        for (i = 0; i < internalInventory.getSize(); ++i) {
            if (internalInventory.getAmount(i) <= 0 || internalInventory.getItem((int)i).item.idData.getStringID().equals(this.activebullet)) continue;
            this.newbullet = internalInventory.getItem((int)i).item.idData.getStringID();
            this.startslot2 = i;
            break;
        }
        for (i = this.startslot2; i < internalInventory.getSize(); ++i) {
            if (internalInventory.getItem(i) == null || internalInventory.getItem((int)i).item.idData.getStringID().equals(this.newbullet)) continue;
            this.endslot2 = i - 1;
            break;
        }
        for (i = 0; i < this.startslot2; ++i) {
            for (int z = 1; z < internalInventory.getSize(); ++z) {
                internalInventory.swapItems(z - 1, z);
            }
        }
        used = true;
        if (used) {
            this.saveInternalInventory(item, internalInventory);
        }
        SoundManager.playSound((GameSound)GameResources.cameraShutter, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(1.3f, 1.4f)));
        for (i = 0; i < internalInventory.getSize(); ++i) {
            int red;
            if (internalInventory.getAmount(i) <= 0) continue;
            if (level.isServer()) break;
            if (internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("ball")) {
                Color avg = new Color(161, 161, 161);
                level.hudManager.addElement((HudDrawElement)new ItemPickupTextSpecial((Mob)attackerMob, internalInventory.getItem(i), avg));
                break;
            }
            if (internalInventory.getItem((int)i).item.getClass().toString().toLowerCase().contains("arrow")) {
                if (this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getAlpha(4, 6) != 0) {
                    red = Math.toIntExact((this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getRed(4, 6) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getRed(6, 8) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getRed(8, 10)) / 3);
                    int green = Math.toIntExact((this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getGreen(4, 6) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getGreen(6, 8) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getGreen(8, 10)) / 3);
                    int blue = Math.toIntExact((this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getBlue(4, 6) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getBlue(6, 8) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getBlue(8, 10)) / 3);
                    Color avg = new Color(red, green, blue);
                    level.hudManager.addElement((HudDrawElement)new ItemPickupTextSpecial((Mob)attackerMob, internalInventory.getItem(i), avg));
                    break;
                }
                red = Math.toIntExact((this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getRed(14, 7) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getRed(14, 9) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getRed(12, 11)) / 3);
                int green = Math.toIntExact((this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getGreen(14, 7) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getGreen(14, 9) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getGreen(12, 11)) / 3);
                int blue = Math.toIntExact((this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getBlue(14, 7) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getBlue(14, 9) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getBlue(12, 11)) / 3);
                Color avg = new Color(red, green, blue);
                level.hudManager.addElement((HudDrawElement)new ItemPickupTextSpecial((Mob)attackerMob, internalInventory.getItem(i), avg));
                break;
            }
            red = Math.toIntExact((this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getRed(13, 15) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getRed(16, 15) + this.getInternalInventory((InventoryItem)item).getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getRed(18, 15)) / 3);
            int green = Math.toIntExact((internalInventory.getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getGreen(13, 15) + internalInventory.getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getGreen(16, 15) + internalInventory.getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getGreen(18, 15)) / 3);
            int blue = Math.toIntExact((internalInventory.getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getBlue(13, 15) + internalInventory.getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getBlue(16, 15) + internalInventory.getItem((int)i).item.getItemSprite((InventoryItem)item, (PlayerMob)attackerMob.getFirstPlayerOwner()).texture.getBlue(18, 15)) / 3);
            if (red + 50 < 255 && blue + 50 < 255 && green + 50 < 255) {
                red += 50;
                blue += 50;
                green += 50;
            }
            Color avg = new Color(red, green, blue);
            level.hudManager.addElement((HudDrawElement)new ItemPickupTextSpecial((Mob)attackerMob, internalInventory.getItem(i), avg));
            break;
        }
        return item;
    }
}

