/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.items.bullets.fuel;

import necesse.engine.localization.Localization;
import necesse.engine.util.GameBlackboard;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.bulletItem.BulletItem;
import rangedarsenal.projectiles.fuel.NapalmBulletProjectile;

public class NapalmBullet
extends BulletItem {
    public NapalmBullet() {
        super(1000);
        this.damage = 3;
        this.armorPen = 2;
        this.rarity = Item.Rarity.COMMON;
        this.stackSize = 5000;
    }

    public boolean overrideProjectile() {
        return true;
    }

    public Projectile getProjectile(float x, float y, float targetX, float targetY, float velocity, int range, GameDamage damage, int knockback, Mob owner) {
        range = Math.round((float)range / 1.3f);
        velocity = Math.round(velocity / 1.35f);
        return new NapalmBulletProjectile(x, y, targetX, targetY, velocity, range, damage, knockback, owner);
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"bullettooltip", (String)"NapalmTip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"FlamethrowerAmmoTip"));
        tooltips.add(Localization.translate((String)"bullettooltip", (String)"NapalmTip2"));
        tooltips.add(Localization.translate((String)"bullettooltip", (String)"NapalmTip3"));
        return tooltips;
    }
}

