/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.events;

import java.awt.Color;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.levelEvent.explosionEvent.ExplosionEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;

public class SlimeSplosionEvent
extends ExplosionEvent
implements Attacker {
    protected ParticleTypeSwitcher explosionTypeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC, Particle.GType.CRITICAL});

    public SlimeSplosionEvent() {
        this(0.0f, 0.0f, 125, new GameDamage(223.0f, 20.0f), false, 0, null);
    }

    public SlimeSplosionEvent(float x, float y, int range, GameDamage damage, boolean destructive, int toolTier, Mob owner) {
        super(x, y, range, damage, destructive, (float)toolTier, owner);
    }

    protected GameDamage getTotalObjectDamage(float targetDistance) {
        return super.getTotalObjectDamage(targetDistance).modDamage(10.0f);
    }

    protected void playExplosionEffects() {
        SoundManager.playSound((GameSound)GameResources.splash, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(0.9f).pitch(0.5f));
        SoundManager.playSound((GameSound)GameResources.fireworkCrack, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(0.7f).pitch(2.5f));
        SoundManager.playSound((GameSound)GameResources.explosionHeavy, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(0.6f).pitch(3.6f));
        SoundManager.playSound((GameSound)GameResources.pop, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(1.0f).pitch(2.9f));
        this.level.getClient().startCameraShake(this.x, this.y, 220, 14, 4.0f, 4.0f, true);
    }

    public float getParticleCount(float currentRange, float lastRange) {
        return super.getParticleCount(currentRange, lastRange) / 1.3f;
    }

    public void spawnExplosionParticle(float x, float y, float dirX, float dirY, int lifeTime, float range) {
        float dy;
        float dx;
        if (GameRandom.globalRandom.getChance(0.7f) && range < 25.0f) {
            dx = dirX * (float)GameRandom.globalRandom.getIntBetween(20, 70);
            dy = dirY * (float)GameRandom.globalRandom.getIntBetween(10, 60) * 0.8f;
            this.getLevel().entityManager.addParticle(x, y, this.explosionTypeSwitcher.next()).sprite(GameResources.liquidBlobParticle.sprite(GameRandom.globalRandom.getIntBetween(0, 4), 0, 12)).sizeFades(70, 80).movesFriction(dx * 0.05f, dy * 0.05f, 0.8f).color(new Color(0, 128, 0)).heightMoves(0.0f, 70.0f).lifeTime(lifeTime * 2);
        }
        if (range <= (float)Math.max(this.range - 125, 25)) {
            dx = dirX * (float)GameRandom.globalRandom.getIntBetween(70, 80);
            dy = dirY * (float)GameRandom.globalRandom.getIntBetween(60, 70) * 0.8f;
            this.getLevel().entityManager.addParticle(x, y, this.explosionTypeSwitcher.next()).sprite(GameResources.liquidBlobParticle.sprite(GameRandom.globalRandom.getIntBetween(0, 4), 0, 12)).sizeFades(30, 50).movesFriction(dx * 0.1f, dy * 0.1f, 2.1f).color(new Color(0, 166, 0)).heightMoves(0.0f, 10.0f).lifeTime(lifeTime * 3);
        }
    }
}

