/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.events;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import necesse.engine.network.Packet;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.mobAbilityLevelEvent.LightningTrailEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.particle.Particle;
import necesse.entity.trails.LightningTrail;
import necesse.entity.trails.Trail;
import necesse.entity.trails.TrailVector;

public class LightningJumperEvent
extends LightningTrailEvent
implements Attacker {
    private static int totalPoints;
    private static final int distance = 70;
    private static final float distanceMod = 1.9f;
    private static final int ticksToComplete = 2;
    private int startX;
    private int startY;
    private int targetX;
    private int targetY;
    private float xDir;
    private float yDir;
    private GameDamage damage;
    private float resilienceGain;
    private int seed;
    private int tickCounter;
    private int pointCounter;
    private ArrayList<Point2D.Float> points;
    private ArrayList<Integer> hits;
    private LightningTrail trail;
    public Mob source;
    public PlayerMob owner;

    public LightningJumperEvent() {
    }

    public LightningJumperEvent(PlayerMob owner, GameDamage damage, float resilienceGain, int startX, int startY, int targetX, int targetY, int seed, Mob mob) {
        this.startX = startX;
        this.startY = startY;
        this.targetX = targetX;
        this.targetY = targetY;
        this.damage = damage.damage == 0.0f ? new GameDamage(30.0f, 0.0f) : new GameDamage(damage.damage / 6.0f, damage.armorPen, 0.0f);
        this.resilienceGain = resilienceGain;
        this.seed = seed;
        this.owner = owner;
        this.source = mob;
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.startX = reader.getNextInt();
        this.startY = reader.getNextInt();
        this.targetX = reader.getNextInt();
        this.targetY = reader.getNextInt();
        this.seed = reader.getNextInt();
        this.tickCounter = reader.getNextShortUnsigned();
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextInt(this.startX);
        writer.putNextInt(this.startY);
        writer.putNextInt(this.targetX);
        writer.putNextInt(this.targetY);
        writer.putNextInt(this.seed);
        writer.putNextShortUnsigned(this.tickCounter);
    }

    public void init() {
        super.init();
        float l = (float)new Point(this.startX, this.startY).distance(this.targetX, this.targetY);
        this.xDir = (float)(this.targetX - this.startX) / l;
        this.yDir = (float)(this.targetY - this.startY) / l;
        this.points = this.generatePoints();
        this.trail = new LightningTrail(new TrailVector((float)this.startX, (float)this.startY, this.xDir, this.yDir, 12.5f, 15.0f), this.level, new Color(128, 100, 194));
        this.trail.addNewPoint(new TrailVector(this.points.get(0), this.xDir, this.yDir, this.trail.thickness, 15.0f));
        if (this.isClient()) {
            this.level.entityManager.addTrail((Trail)this.trail);
        }
        this.hits = new ArrayList();
        totalPoints = this.source.idData.getStringID().equalsIgnoreCase("pestwarden") || this.source.idData.getStringID().equalsIgnoreCase("pestwardenbody") || this.source.idData.getStringID().equalsIgnoreCase("swampguardian") || this.source.idData.getStringID().equalsIgnoreCase("swampguardianbody") || this.source.idData.getStringID().equalsIgnoreCase("swampguardiantail") ? 6 : (this.source.idData.getStringID().equalsIgnoreCase("sage") || this.source.idData.getStringID().equalsIgnoreCase("grit") || this.source.idData.getStringID().equalsIgnoreCase("flyingspiritsbody") ? 9 : 13);
    }

    public void clientTick() {
        if (!this.isOver()) {
            ++this.tickCounter;
            int expectedCounter = this.tickCounter * totalPoints / 2;
            while (this.pointCounter < expectedCounter) {
                int j;
                Point2D.Float point;
                block11: {
                    ++this.pointCounter;
                    if (this.pointCounter >= totalPoints) {
                        this.over();
                        break;
                    }
                    point = null;
                    if (this.points.size() < this.pointCounter) {
                        try {
                            point = this.points.get(this.points.size() - 1);
                            break block11;
                        }
                        catch (Exception e) {
                            this.over();
                            break;
                        }
                    }
                    try {
                        point = this.points.get(this.pointCounter);
                    }
                    catch (Exception e) {
                        this.over();
                        break;
                    }
                }
                if (point == null) continue;
                this.trail.addNewPoint(new TrailVector(point, this.xDir, this.yDir, this.trail.thickness, 15.0f));
                Point2D.Float lastPoint = this.points.get(this.pointCounter - 1);
                Point2D.Float midPoint = new Point2D.Float((point.x + lastPoint.x) / 2.0f, (point.y + lastPoint.y) / 2.0f);
                Point2D.Float norm = GameMath.normalize((float)(point.x - lastPoint.x), (float)(point.y - lastPoint.y));
                float distance = (float)point.distance(lastPoint);
                for (j = 0; j < 1; ++j) {
                    this.level.entityManager.addParticle(midPoint.x + norm.x * GameRandom.globalRandom.nextFloat() * distance, midPoint.y + norm.y * GameRandom.globalRandom.nextFloat() * distance, Particle.GType.COSMETIC).movesConstant((float)(GameRandom.globalRandom.nextGaussian() * 1.0), (float)(GameRandom.globalRandom.nextGaussian() * 1.0)).color(this.trail.col).height(15.0f);
                }
                if (this.pointCounter == 2) {
                    for (j = 0; j < 1; ++j) {
                        this.level.entityManager.addParticle(lastPoint.x + norm.x * 4.0f, lastPoint.y + norm.y * 4.0f, Particle.GType.COSMETIC).movesConstant((float)(GameRandom.globalRandom.nextGaussian() * 20.0), (float)(GameRandom.globalRandom.nextGaussian() * 20.0)).color(this.trail.col).height(25.0f).lifeTime(250);
                    }
                }
                if (this.source == null || this.source.getLevel().entityManager.mobs.streamArea(point.x, point.y, 1) == null) continue;
                Point2D.Float finalPoint = point;
                this.source.getLevel().entityManager.mobs.streamArea(point.x, point.y, 1).forEach(m -> {
                    if (m != this.source && m.x <= finalPoint.x + 33.0f && m.x >= finalPoint.x - 33.0f && m.y <= finalPoint.y + 33.0f && m.y >= finalPoint.y - 33.0f && !m.isSameTeam((Mob)this.owner) && (!m.isPlayer && m.canBeHit((Attacker)this.owner) || m.isPlayer && this.owner.getServerClient().pvpEnabled) && !this.hasHit((Mob)m)) {
                        int damage;
                        ActiveBuff ab;
                        if ((this.source.idData.getStringID().equalsIgnoreCase("swampguardian") || this.source.idData.getStringID().equalsIgnoreCase("swampguardianbody") || this.source.idData.getStringID().equalsIgnoreCase("swampguardiantail")) && (m.idData.getStringID().equalsIgnoreCase("swampguardian") || m.idData.getStringID().equalsIgnoreCase("swampguardianbody") || m.idData.getStringID().equalsIgnoreCase("swampguardiantail"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 5.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("pestwarden") || this.source.idData.getStringID().equalsIgnoreCase("pestwardenbody")) && (m.idData.getStringID().equalsIgnoreCase("pestwarden") || m.idData.getStringID().equalsIgnoreCase("pestwardenbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 5.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("sage") || this.source.idData.getStringID().equalsIgnoreCase("flyingspiritsbody")) && (m.idData.getStringID().equalsIgnoreCase("sage") || m.idData.getStringID().equalsIgnoreCase("flyingspiritsbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 7.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("grit") || this.source.idData.getStringID().equalsIgnoreCase("flyingspiritsbody")) && (m.idData.getStringID().equalsIgnoreCase("grit") || m.idData.getStringID().equalsIgnoreCase("flyingspiritsbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 7.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("crystaldragon") || this.source.idData.getStringID().equalsIgnoreCase("crystaldragonbody")) && (m.idData.getStringID().equalsIgnoreCase("crystaldragon") || m.idData.getStringID().equalsIgnoreCase("crystaldragonbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 2.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("slimeworm") || this.source.idData.getStringID().equalsIgnoreCase("slimewormbody")) && (m.idData.getStringID().equalsIgnoreCase("slimeworm") || m.idData.getStringID().equalsIgnoreCase("slimewormbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 10.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("sandworm") || this.source.idData.getStringID().equalsIgnoreCase("sandwormbody") || this.source.idData.getStringID().equalsIgnoreCase("sandwormtail")) && (m.idData.getStringID().equalsIgnoreCase("sandworm") || m.idData.getStringID().equalsIgnoreCase("sandwormbody") || m.idData.getStringID().equalsIgnoreCase("sandwormtail"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 10.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((damage = m.buffManager.getBuff("LightningBlockerDebuff") != null ? Math.round(this.damage.damage - (float)m.buffManager.getBuff("LightningBlockerDebuff").getStacks() / 2.0f) : Math.round(this.damage.damage)) > 50) {
                            damage = 50;
                        } else if (damage <= 0) {
                            damage = 1;
                        }
                        m.setHealth(m.getHealth() - damage, (Attacker)this.owner);
                        m.spawnDamageText(damage, 12, false);
                        this.hits.add(m.getUniqueID());
                    }
                });
            }
        }
    }

    public void serverTick() {
        if (!this.isOver()) {
            ++this.tickCounter;
            int expectedCounter = this.tickCounter * totalPoints / 2;
            while (this.pointCounter < expectedCounter) {
                Point2D.Float point;
                block8: {
                    ++this.pointCounter;
                    if (this.pointCounter >= totalPoints) {
                        this.over();
                        break;
                    }
                    point = null;
                    if (this.points.size() < this.pointCounter) {
                        try {
                            point = this.points.get(this.points.size() - 1);
                            break block8;
                        }
                        catch (Exception e) {
                            this.over();
                            break;
                        }
                    }
                    try {
                        point = this.points.get(this.pointCounter);
                    }
                    catch (Exception e) {
                        this.over();
                        break;
                    }
                }
                if (point == null || this.source == null || this.source.getLevel().entityManager.mobs.streamArea(point.x, point.y, 1) == null) continue;
                Point2D.Float finalPoint = point;
                this.source.getLevel().entityManager.mobs.streamArea(point.x, point.y, 1).forEach(m -> {
                    if (m != this.source && m.x <= finalPoint.x + 33.0f && m.x >= finalPoint.x - 33.0f && m.y <= finalPoint.y + 33.0f && m.y >= finalPoint.y - 33.0f && !m.isSameTeam((Mob)this.owner) && (!m.isPlayer && m.canBeHit((Attacker)this.owner) || m.isPlayer && this.owner.getServerClient().pvpEnabled) && !this.hasHit((Mob)m)) {
                        int damage;
                        ActiveBuff ab;
                        if ((this.source.idData.getStringID().equalsIgnoreCase("swampguardian") || this.source.idData.getStringID().equalsIgnoreCase("swampguardianbody") || this.source.idData.getStringID().equalsIgnoreCase("swampguardiantail")) && (m.idData.getStringID().equalsIgnoreCase("swampguardian") || m.idData.getStringID().equalsIgnoreCase("swampguardianbody") || m.idData.getStringID().equalsIgnoreCase("swampguardiantail"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 5.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("pestwarden") || this.source.idData.getStringID().equalsIgnoreCase("pestwardenbody")) && (m.idData.getStringID().equalsIgnoreCase("pestwarden") || m.idData.getStringID().equalsIgnoreCase("pestwardenbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 5.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("sage") || this.source.idData.getStringID().equalsIgnoreCase("flyingspiritsbody")) && (m.idData.getStringID().equalsIgnoreCase("sage") || m.idData.getStringID().equalsIgnoreCase("flyingspiritsbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 7.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("grit") || this.source.idData.getStringID().equalsIgnoreCase("flyingspiritsbody")) && (m.idData.getStringID().equalsIgnoreCase("grit") || m.idData.getStringID().equalsIgnoreCase("flyingspiritsbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 7.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("crystaldragon") || this.source.idData.getStringID().equalsIgnoreCase("crystaldragonbody")) && (m.idData.getStringID().equalsIgnoreCase("crystaldragon") || m.idData.getStringID().equalsIgnoreCase("crystaldragonbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 2.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("slimeworm") || this.source.idData.getStringID().equalsIgnoreCase("slimewormbody")) && (m.idData.getStringID().equalsIgnoreCase("slimeworm") || m.idData.getStringID().equalsIgnoreCase("slimewormbody"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 10.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((this.source.idData.getStringID().equalsIgnoreCase("sandworm") || this.source.idData.getStringID().equalsIgnoreCase("sandwormbody") || this.source.idData.getStringID().equalsIgnoreCase("sandwormtail")) && (m.idData.getStringID().equalsIgnoreCase("sandworm") || m.idData.getStringID().equalsIgnoreCase("sandwormbody") || m.idData.getStringID().equalsIgnoreCase("sandwormtail"))) {
                            ab = new ActiveBuff("LightningBlockerDebuff", m, 10.0f, (Attacker)m);
                            m.addBuff(ab, true);
                        }
                        if ((damage = m.buffManager.getBuff("LightningBlockerDebuff") != null ? Math.round(this.damage.damage - (float)m.buffManager.getBuff("LightningBlockerDebuff").getStacks() / 2.0f) : Math.round(this.damage.damage)) > 50) {
                            damage = 50;
                        } else if (damage <= 0) {
                            damage = 1;
                        }
                        m.setHealth(m.getHealth() - damage, (Attacker)this.owner);
                        this.hits.add(m.getUniqueID());
                    }
                });
            }
        }
    }

    private ArrayList<Point2D.Float> generatePoints() {
        ArrayList<Point2D.Float> out = new ArrayList<Point2D.Float>();
        GameRandom random = new GameRandom((long)this.seed);
        Point2D.Float perp = new Point2D.Float(-this.yDir, this.xDir);
        float lastDist = 0.0f;
        Point2D.Float lastPoint = new Point2D.Float(this.startX, this.startY);
        out.add(lastPoint);
        totalPoints = this.source.idData.getStringID().equalsIgnoreCase("pestwarden") || this.source.idData.getStringID().equalsIgnoreCase("pestwardenbody") || this.source.idData.getStringID().equalsIgnoreCase("swampguardian") || this.source.idData.getStringID().equalsIgnoreCase("swampguardianbody") || this.source.idData.getStringID().equalsIgnoreCase("swampguardiantail") ? 6 : (this.source.idData.getStringID().equalsIgnoreCase("sage") || this.source.idData.getStringID().equalsIgnoreCase("grit") || this.source.idData.getStringID().equalsIgnoreCase("flyingspiritsbody") ? 9 : 13);
        for (int i = 0; i < totalPoints; ++i) {
            float fluctuation = (random.nextFloat() - 0.5f) * lastDist * 2.0f;
            lastDist = (random.nextFloat() + 1.9f) * 8.5f;
            lastPoint = new Point2D.Float(lastPoint.x + this.xDir * lastDist - perp.x * fluctuation, lastPoint.y + this.yDir * lastDist - perp.y * fluctuation);
            out.add(lastPoint);
        }
        return out;
    }

    public void serverHit(Mob target, Packet content, boolean clientSubmitted) {
        super.serverHit(target, content, clientSubmitted);
        target.isServerHit(this.damage, 0.0f, 0.0f, 0.0f, (Attacker)this);
        this.hits.add(target.getUniqueID());
        if (target.canGiveResilience((Attacker)this.owner) && this.resilienceGain != 0.0f) {
            this.owner.addResilience(this.resilienceGain);
            this.resilienceGain = 0.2f;
        }
    }

    public boolean hasHit(Mob mob) {
        return this.hits.contains(mob.getUniqueID());
    }
}

