/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.events;

import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.explosionEvent.ExplosionEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.gfx.GameResources;
import necesse.level.maps.Level;

public class GrenadeLauncherSpeedExplosionEvent
extends ExplosionEvent
implements Attacker {
    public GrenadeLauncherSpeedExplosionEvent() {
        this(0.0f, 0.0f, new GameDamage(57.0f, 15.0f), null);
        this.destroysTiles = false;
        this.targetRangeMod = 0.66f;
        this.range = 68;
        this.owner = -1;
        this.knockback = 75;
        this.hitsOwner = true;
        this.sendOwnerData = true;
        this.sendCustomData = true;
    }

    public GrenadeLauncherSpeedExplosionEvent(float x, float y, GameDamage damage, Mob owner) {
        super(x, y, 75, damage, false, 0.0f, owner);
        this.sendCustomData = true;
        this.sendOwnerData = true;
    }

    public static void spawnExplosionParticles(Level level, float x, float y, int particles, float minRange, float maxRange, ExplosionEvent.ExplosionSpawnFunction spawnFunction) {
        for (int i = 0; i <= particles; ++i) {
            float anglePerParticle = 360.0f / (float)particles;
            int angle = (int)((float)i * anglePerParticle + GameRandom.globalRandom.nextFloat() * anglePerParticle);
            float range = GameRandom.globalRandom.getFloatBetween(minRange, maxRange) / 5.0f;
            float dx = (float)Math.sin(Math.toRadians(angle));
            float dy = (float)Math.cos(Math.toRadians(angle));
            spawnFunction.spawn(level, x + dx * range, y + dy * range, dx * 20.0f, dy * 20.0f, 400, range);
        }
    }

    protected void playExplosionEffects() {
        SoundManager.playSound((GameSound)GameResources.explosionHeavy, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(1.0f).pitch(1.6f));
        this.level.getClient().startCameraShake(this.x, this.y, 200, 50, 1.5f, 1.5f, true);
    }
}

