/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.events;

import java.awt.Color;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.levelEvent.explosionEvent.ExplosionEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;

public class FruitBoomEvent
extends ExplosionEvent
implements Attacker {
    protected ParticleTypeSwitcher explosionTypeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC, Particle.GType.CRITICAL});
    public String foodtype;

    public FruitBoomEvent() {
        this(0.0f, 0.0f, 45, new GameDamage(8.0f, 0.0f, 0.0f), false, 0, null, null);
        this.sendCustomData = false;
        this.sendOwnerData = true;
        this.knockback = 10;
    }

    public FruitBoomEvent(float x, float y, int range, GameDamage damage, boolean destructive, int toolTier, Mob owner, String food) {
        super(x, y, range, damage, destructive, (float)toolTier, owner);
        this.sendCustomData = false;
        this.sendOwnerData = true;
        this.knockback = 10;
        this.foodtype = food;
    }

    protected GameDamage getTotalObjectDamage(float targetDistance) {
        return super.getTotalObjectDamage(targetDistance).modDamage(1.0f);
    }

    protected void playExplosionEffects() {
        if (this.foodtype != null) {
            if (this.foodtype.equals("corn")) {
                SoundManager.playSound((GameSound)GameResources.fireworkCrack, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(2.0f).pitch(1.0f));
            } else if (this.foodtype.equals("tomato")) {
                SoundManager.playSound((GameSound)GameResources.npcdeath, (SoundEffect)SoundEffect.effect((float)this.x, (float)this.y).volume(0.8f).pitch(1.8f));
            }
        }
    }

    public float getParticleCount(float currentRange, float lastRange) {
        return super.getParticleCount(currentRange, lastRange) / 15.0f;
    }

    public void spawnExplosionParticle(float x, float y, float dirX, float dirY, int lifeTime, float range) {
        float dx = dirX * 5.0f;
        float dy = dirY * 5.0f * 0.8f;
        lifeTime = 165;
        if (this.foodtype != null) {
            if (this.foodtype.equals("corn")) {
                this.getLevel().entityManager.addParticle(x, y, this.explosionTypeSwitcher.next()).sprite(GameResources.liquidBlobParticle.sprite(GameRandom.globalRandom.getIntBetween(0, 4), 0, 12)).sizeFades(30, 40).movesFriction(dx * 0.05f, dy * 0.05f, 0.1f).color(new Color(243, 236, 109)).heightMoves(0.0f, 1.0f).lifeTime(lifeTime);
            } else if (this.foodtype.equals("tomato")) {
                this.getLevel().entityManager.addParticle(x, y, this.explosionTypeSwitcher.next()).sprite(GameResources.liquidBlobParticle.sprite(GameRandom.globalRandom.getIntBetween(0, 4), 0, 12)).sizeFades(30, 40).movesFriction(dx * 0.05f, dy * 0.05f, 0.1f).color(new Color(117, 2, 2)).heightMoves(0.0f, 1.0f).lifeTime(lifeTime);
            } else if (this.foodtype.equals("onion")) {
                this.getLevel().entityManager.addParticle(x, y, this.explosionTypeSwitcher.next()).sprite(GameResources.liquidBlobParticle.sprite(GameRandom.globalRandom.getIntBetween(0, 4), 0, 12)).sizeFades(30, 40).movesFriction(dx * 0.05f, dy * 0.05f, 0.1f).color(new Color(117, 2, 2, 0)).heightMoves(0.0f, 1.0f).lifeTime(lifeTime);
            }
        } else {
            this.getLevel().entityManager.addParticle(x, y, this.explosionTypeSwitcher.next()).sprite(GameResources.liquidBlobParticle.sprite(GameRandom.globalRandom.getIntBetween(0, 4), 0, 12)).sizeFades(30, 40).movesFriction(dx * 0.05f, dy * 0.05f, 0.1f).color(new Color(238, 191, 10, 0)).heightMoves(0.0f, 1.0f).lifeTime(lifeTime);
        }
    }
}

