/*
 * Decompiled with CFR 0.152.
 */
package rangedarsenal.events;

import java.util.function.Supplier;
import necesse.engine.network.PacketReader;
import necesse.engine.network.PacketWriter;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.ParticleTypeSwitcher;
import necesse.entity.levelEvent.mobAbilityLevelEvent.MobAbilityLevelEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.particle.Particle;
import necesse.gfx.GameResources;
import necesse.gfx.gameTexture.GameTextureSection;

public class CrystalSplosionEvent
extends MobAbilityLevelEvent {
    protected ParticleType type;
    protected Mob source;
    protected Mob owner;

    public CrystalSplosionEvent() {
    }

    public CrystalSplosionEvent(Mob owner, Mob source) {
        super(owner, new GameRandom());
        this.type = ParticleType.SAPPHIRE;
        this.owner = owner;
        this.source = source;
    }

    public void applySpawnPacket(PacketReader reader) {
        super.applySpawnPacket(reader);
        this.type = (ParticleType)reader.getNextEnum(ParticleType.class);
    }

    public void setupSpawnPacket(PacketWriter writer) {
        super.setupSpawnPacket(writer);
        writer.putNextEnum((Enum)this.type);
    }

    public void init() {
        super.init();
        if (this.isClient() && this.owner != null) {
            this.shatterCrystallizeBuff();
        }
        this.over();
    }

    public void shatterCrystallizeBuff() {
        SoundManager.playSound((GameSound)GameResources.shatter2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)this.owner).volume(2.0f).pitch(1.0f));
        this.spawnShatterParticles();
    }

    private void spawnShatterParticles() {
        int particleCount = 25;
        GameRandom random = GameRandom.globalRandom;
        ParticleTypeSwitcher typeSwitcher = new ParticleTypeSwitcher(new Particle.GType[]{Particle.GType.CRITICAL, Particle.GType.IMPORTANT_COSMETIC, Particle.GType.COSMETIC});
        float anglePerParticle = 360.0f / (float)particleCount;
        GameTextureSection textureSection = this.type.textureGetter.get();
        for (int i = 0; i < particleCount; ++i) {
            int angle = (int)((float)i * anglePerParticle + random.nextFloat() * anglePerParticle);
            float dx = (float)Math.sin(Math.toRadians(angle)) * 50.0f;
            float dy = (float)Math.cos(Math.toRadians(angle)) * 50.0f;
            this.owner.getLevel().entityManager.addParticle((Entity)this.owner, typeSwitcher.next()).sprite(textureSection.sprite(random.nextInt(4), 0, 18, 24)).sizeFades(22, 44).movesFriction(dx * random.getFloatBetween(1.0f, 2.0f), dy * random.getFloatBetween(1.0f, 2.0f), 0.8f).heightMoves(0.0f, -30.0f).lifeTime(500);
        }
    }

    public static enum ParticleType {
        AMETHYST(() -> GameResources.amethystShardParticles),
        SAPPHIRE(() -> GameResources.sapphireShardParticles),
        EMERALD(() -> GameResources.emeraldShardParticles),
        RUBY(() -> GameResources.rubyShardParticles);

        public Supplier<GameTextureSection> textureGetter;

        private ParticleType(Supplier textureGetter) {
            this.textureGetter = textureGetter;
        }
    }
}

