/*
 * Decompiled with CFR 0.152.
 */
package advancedsummons.items.basicsummons.surfacebosses;

import java.awt.geom.Line2D;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.registries.BiomeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.consumableItem.ConsumableItem;
import necesse.inventory.recipe.Ingredient;
import necesse.level.maps.IncursionLevel;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;

public class PirateCaptain
extends ConsumableItem {
    public static String id = "piratecaptain";
    public static Ingredient recipe = new Ingredient("piratemap", 3);

    public PirateCaptain() {
        super(1, false);
        this.itemCooldownTime.setBaseValue(2000);
        this.setItemCategory(new String[]{"consumable", "bossitems"});
        this.dropsAsMatDeathPenalty = false;
        this.keyWords.add("boss");
        this.keyWords.add("advanced");
        this.keyWords.add("basic");
        this.rarity = Item.Rarity.LEGENDARY;
        this.worldDrawSize = 32;
        this.incinerationTimeMillis = 30000;
    }

    public String canPlace(Level level, int x, int y, PlayerMob player, Line2D playerPositionLine, InventoryItem item, GNDItemMap mapContent) {
        if (level instanceof IncursionLevel) {
            return "inincursion";
        }
        return level.baseBiome != BiomeRegistry.PIRATE_VILLAGE ? "portalnotpirate" : null;
    }

    public InventoryItem onAttemptPlace(Level level, int x, int y, PlayerMob player, InventoryItem item, GNDItemMap mapContent, String error) {
        if (level.isServer() && player != null && player.isServerClient() && error.equals("inincursion")) {
            player.getServerClient().sendChatMessage((GameMessage)new LocalMessage("misc", "cannotsummoninincursion"));
        }
        return item;
    }

    public InventoryItem onPlace(Level level, int x, int y, PlayerMob player, int seed, InventoryItem item, GNDItemMap mapContent) {
        if (level.isServer()) {
            GameMessage summonError;
            if (level instanceof IncursionLevel && (summonError = ((IncursionLevel)level).canSummonBoss("piratecaptain")) != null) {
                if (player != null && player.isServerClient()) {
                    player.getServerClient().sendChatMessage(summonError);
                }
                return item;
            }
            System.out.println("Pirate Captain has been summoned at " + level.getIdentifier() + ".");
            float angle = GameRandom.globalRandom.nextInt(360);
            float nx = (float)Math.cos(Math.toRadians(angle));
            float ny = (float)Math.sin(Math.toRadians(angle));
            float distance = 960.0f;
            Mob mob = MobRegistry.getMob((String)"piratecaptain", (Level)level);
            level.entityManager.addMob(mob, (float)(x + (int)(nx * distance)), (float)(y + (int)(ny * distance)));
            level.getServer().network.sendToClientsWithEntity((Packet)new PacketChatMessage((GameMessage)new LocalMessage("misc", "bosssummon", "name", mob.getLocalization())), (RegionPositionGetter)mob);
            if (level instanceof IncursionLevel) {
                ((IncursionLevel)level).onBossSummoned(mob);
            }
        }
        return item;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"piratecaptainsummontip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"infiniteuse"));
        return tooltips;
    }

    public String getTranslatedTypeName() {
        return Localization.translate((String)"item", (String)"relic");
    }
}

