/*
 * Decompiled with CFR 0.152.
 */
package advancedsummons.items.basicsummons.deepcaves;

import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketMobChat;
import necesse.engine.registries.BiomeRegistry;
import necesse.engine.registries.MobRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.engine.util.GameUtils;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.consumableItem.ConsumableItem;
import necesse.inventory.recipe.Ingredient;
import necesse.level.maps.IncursionLevel;
import necesse.level.maps.Level;
import necesse.level.maps.biomes.dungeon.DungeonArenaLevel;

public class FallenWizard
extends ConsumableItem {
    public static String id = "fallenwizard";
    public static Ingredient recipe = new Ingredient("anytempleloot", 1);

    public FallenWizard() {
        super(1, false);
        this.itemCooldownTime.setBaseValue(2000);
        this.setItemCategory(new String[]{"consumable", "bossitems"});
        this.dropsAsMatDeathPenalty = false;
        this.keyWords.add("boss");
        this.keyWords.add("advanced");
        this.keyWords.add("basic");
        this.rarity = Item.Rarity.LEGENDARY;
        this.worldDrawSize = 32;
        this.incinerationTimeMillis = 30000;
    }

    public String canPlace(Level level, int x, int y, PlayerMob player, Line2D playerPositionLine, InventoryItem item, GNDItemMap mapContent) {
        System.out.println(level.getIslandDimension());
        if (level instanceof IncursionLevel) {
            return null;
        }
        if (level.getIslandDimension() == -201 && level.baseBiome == BiomeRegistry.TEMPLE) {
            return level.entityManager.mobs.streamInRegionsShape((Shape)GameUtils.rangeTileBounds((int)x, (int)y, (int)150), 0).anyMatch(m -> m.getStringID().equals("fallenwizard")) ? "alreadyspawned" : null;
        }
        return "portalnotwizard";
    }

    public InventoryItem onPlace(Level level, int x, int y, PlayerMob player, int seed, InventoryItem item, GNDItemMap mapContent) {
        if (level.isServer()) {
            Point2D.Float bossPos;
            GameMessage summonError;
            if (level instanceof IncursionLevel && (summonError = ((IncursionLevel)level).canSummonBoss("reaper")) != null) {
                if (player != null && player.isServerClient()) {
                    player.getServerClient().sendChatMessage(summonError);
                }
                return item;
            }
            Mob mob = MobRegistry.getMob((String)"fallenwizard", (Level)level);
            if (level.getIslandDimension() == -101 && level.baseBiome == BiomeRegistry.TEMPLE) {
                bossPos = DungeonArenaLevel.getBossPosition();
            } else {
                ArrayList<Point> spawnPoints = new ArrayList<Point>();
                int pTileX = x / 32;
                int pTileY = y / 32;
                for (int i = -10; i <= 10; ++i) {
                    for (int j = -10; j <= 10; ++j) {
                        int tileX = pTileX + i;
                        int tileY = pTileY + j;
                        if (level.isLiquidTile(tileX, tileY) || level.isShore(tileX, tileY) || mob.collidesWith(level, tileX * 32 + 16, tileY * 32 + 16)) continue;
                        spawnPoints.add(new Point(tileX, tileY));
                    }
                }
                Point spawnPoint = !spawnPoints.isEmpty() ? (Point)GameRandom.globalRandom.getOneOf(spawnPoints) : new Point(x + GameRandom.globalRandom.getIntBetween(-8, 8), y + GameRandom.globalRandom.getIntBetween(-8, 8));
                bossPos = new Point2D.Float(spawnPoint.x * 32 + 16, spawnPoint.y * 32 + 16);
            }
            level.entityManager.addMob(mob, bossPos.x, bossPos.y);
            System.out.println("Fallen Wizard has been summoned at " + level.getIdentifier() + ".");
            if (level instanceof IncursionLevel) {
                ((IncursionLevel)level).onBossSummoned(mob);
            }
        }
        return item;
    }

    public InventoryItem onAttemptPlace(Level level, int x, int y, PlayerMob player, InventoryItem item, GNDItemMap mapContent, String error) {
        if (level.isServer() && error.equals("notinarena")) {
            level.getServer().network.sendPacket((Packet)new PacketMobChat(player.getUniqueID(), "itemtooltip", "callernoarena"), player.getServerClient());
        }
        return item;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"fallenwizardsummontip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"infiniteuse"));
        return tooltips;
    }

    public String getTranslatedTypeName() {
        return Localization.translate((String)"item", (String)"relic");
    }
}

