/*
 * Decompiled with CFR 0.152.
 */
package advancedsummons.items;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import necesse.engine.localization.Localization;
import necesse.engine.localization.message.GameMessage;
import necesse.engine.localization.message.LocalMessage;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketChatMessage;
import necesse.engine.registries.ClassIDDataContainer;
import necesse.engine.registries.MobRegistry;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.placeableItem.consumableItem.ConsumableItem;
import necesse.level.maps.Level;

public class DimensionSummon
extends ConsumableItem {
    public String[] DimensionalFractureBosses = new String[]{"evilsprotector", "queenspider", "voidwizard", "chieftain", "swampguardian", "ancientvulture", "piratecaptain", "reaper", "cryoqueen", "pestwarden", "sage", "grit", "fallenwizard", "motherslime", "nightswarm", "spiderempress", "crystaldragon", "sunlightchampion", "moonlightdancer"};

    public DimensionSummon() {
        super(1, false);
        this.itemCooldownTime.setBaseValue(100);
        this.setItemCategory(new String[]{"consumable", "bossitems"});
        this.dropsAsMatDeathPenalty = false;
        this.keyWords.add("boss");
        this.keyWords.add("summon");
        this.keyWords.add("advanced");
        this.rarity = Item.Rarity.LEGENDARY;
        this.worldDrawSize = 32;
        this.incinerationTimeMillis = 30000;
    }

    public boolean getConstantUse(InventoryItem item) {
        return false;
    }

    public InventoryItem onPlace(Level level, int x, int y, PlayerMob player, int seed, InventoryItem item, GNDItemMap mapContent) {
        if (level.isServer()) {
            HashSet<String> bosses = new HashSet<String>();
            List clonedlist = MobRegistry.getMobs();
            for (ClassIDDataContainer var : clonedlist) {
                if (!MobRegistry.isBossMob((int)var.getID())) continue;
                bosses.add(var.getStringID());
            }
            for (String mobStringID : bosses) {
                Mob mob = MobRegistry.getMob((String)mobStringID, (Level)level);
                Point spawnPoint = this.findSpawnLocation(level, mob, player.getX() / 32, player.getY() / 32, 80);
                level.entityManager.addMob(mob, (float)spawnPoint.x, (float)spawnPoint.y);
            }
            level.getServer().network.sendToAllClients((Packet)new PacketChatMessage((GameMessage)new LocalMessage("misc", "dimensionalfracturechatmessage", "name", player.playerName)));
        }
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.pop, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)player).pitch(0.8f));
        }
        return item;
    }

    protected Point findSpawnLocation(Level level, Mob mob, int tileX, int tileY, int maxTileRange) {
        ArrayList<Point> possibleSpawns = new ArrayList<Point>();
        for (int x = tileX - maxTileRange; x <= tileX + maxTileRange; ++x) {
            for (int y = tileY - maxTileRange; y <= tileY + maxTileRange; ++y) {
                int posY;
                int posX;
                if (x == tileX && y == tileY || mob.collidesWith(level, posX = x * 32 + 16, posY = y * 32 + 16)) continue;
                possibleSpawns.add(new Point(posX, posY));
            }
        }
        if (!possibleSpawns.isEmpty()) {
            return (Point)possibleSpawns.get(GameRandom.globalRandom.nextInt(possibleSpawns.size()));
        }
        return new Point(tileX * 32 + 16, tileY * 32 + 16);
    }

    public String canPlace(Level level, int x, int y, PlayerMob player, Line2D playerPositionLine, InventoryItem item, GNDItemMap mapContent) {
        return null;
    }

    public ListGameTooltips getTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"dimensionalfracturetooltip"));
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"infiniteuse"));
        return tooltips;
    }
}

