/*
 * Decompiled with CFR 0.152.
 */
package oddities.registry;

import necesse.engine.network.gameNetworkData.GNDItem;
import necesse.engine.network.gameNetworkData.GNDItemEnchantment;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.RecipeTechRegistry;
import necesse.inventory.item.ItemCategory;
import necesse.inventory.item.ItemCategoryManager;
import necesse.inventory.recipe.Ingredient;
import necesse.inventory.recipe.Recipe;
import necesse.inventory.recipe.Recipes;
import necesse.inventory.recipe.Tech;
import oddities.registry.ModRecipeTechs;

public class ModRecipes {
    private final String[] categories = new String[]{"Keen", "Nimble", "Quick", "Sturdy", "Precise", "Bulky", "Magical", "Tenacious", "Tough", "Berserk", "Adamant", "Agile", "Harmful", "Grand", "Masterful", "Skillful", "Tightened", "Modern", "Trained", "Divine", "Wrathful", "Wise", "Adept", "Apprentice", "Savage", "Athletic", "Mindful", "Proud", "Aware", "Master", "Shining", "Sharp"};

    public ModRecipes() {
        this.CreateCategories();
        this.MagicWeapons();
        this.MeleeWeapons();
        this.RangeWeapons();
        this.ObjectCrafting();
        this.ScriptTable();
        this.TinkerTable();
        this.Potions();
        this.Tools();
        this.Misc();
        this.Materials();
    }

    public void MagicWeapons() {
        Recipes.registerModRecipe((Recipe)new Recipe("waterboltweapon", 1, RecipeTechRegistry.FALLEN_ANVIL, new Ingredient[]{new Ingredient("book", 1), new Ingredient("sapphire", 25), new Ingredient("glacialbar", 10)}).showAfter("shadowbeam"));
        Recipes.registerModRecipe((Recipe)new Recipe("iceshardsweapon", 1, RecipeTechRegistry.DEMONIC_ANVIL, new Ingredient[]{new Ingredient("book", 1), new Ingredient("frostshard", 20)}).showAfter("haematomeweapon"));
        Recipes.registerModRecipe((Recipe)new Recipe("haematomeweapon", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, new Ingredient[]{new Ingredient("bloodvolley", 1), new Ingredient("lifequartz", 50), new Ingredient("ruby", 5), new Ingredient("ectoplasm", 10)}).showAfter("bloodvolley"));
    }

    public void MeleeWeapons() {
        Recipes.registerModRecipe((Recipe)new Recipe("imbuedkatana", 1, RecipeTechRegistry.FALLEN_ANVIL, new Ingredient[]{new Ingredient("reinforcedkatana", 1), new Ingredient("venomslasher", 1), new Ingredient("upgradeshard", 250), new Ingredient("omnicrystal", 25), new Ingredient("pearlescentdiamond", 25), new Ingredient("lifequartz", 50)}).showBefore("slimegreatsword"));
        Recipes.registerModRecipe((Recipe)new Recipe("manastealweapon1", 1, RecipeTechRegistry.DEMONIC_ANVIL, new Ingredient[]{new Ingredient("manapotion", 10), new Ingredient("goldbar", 5), new Ingredient("demonicbar", 5), new Ingredient("anylog", 3)}));
        Recipes.registerModRecipe((Recipe)new Recipe("manastealweapon2", 1, RecipeTechRegistry.TUNGSTEN_ANVIL, new Ingredient[]{new Ingredient("manastealweapon1", 1), new Ingredient("greatermanapotion", 25), new Ingredient("manaregenpotion", 25), new Ingredient("tungstenbar", 15), new Ingredient("runestone", 20)}));
        Recipes.registerModRecipe((Recipe)new Recipe("manastealweapon3", 1, RecipeTechRegistry.FALLEN_ANVIL, new Ingredient[]{new Ingredient("manastealweapon2", 1), new Ingredient("superiormanapotion", 25), new Ingredient("greatermanaregenpotion", 25), new Ingredient("infinitiumbarmaterial", 10), new Ingredient("upgradeshard", 100)}));
    }

    public void RangeWeapons() {
    }

    public void ObjectCrafting() {
        Recipes.registerModRecipe((Recipe)new Recipe("scrolltable", 1, RecipeTechRegistry.FALLEN_WORKSTATION, new Ingredient[]{new Ingredient("lifequartz", 20), new Ingredient("amethyst", 2), new Ingredient("emerald", 2), new Ingredient("ruby", 2), new Ingredient("sapphire", 2), new Ingredient("upgradeshard", 50)}));
    }

    public void ScriptTable() {
        for (String category : this.categories) {
            Recipes.registerModRecipe((Recipe)new Recipe("enchantingscroll", 1, ModRecipeTechs.SCRIPT_TABLE, new Ingredient[]{new Ingredient("tatteredscroll", 3), new Ingredient("alchemyshard", 25), new Ingredient("lifequartz", 5), new Ingredient("upgradeshard", 50)}).setCraftingCategory(new String[]{category}).onCrafted(event -> event.resultItem.setGndData(new GNDItemMap().setItem("enchantment", (GNDItem)new GNDItemEnchantment(category.toLowerCase())))));
        }
    }

    public void TinkerTable() {
        Recipes.registerModRecipe((Recipe)new Recipe("clockworksoultrinket", 1, ModRecipeTechs.TRINKET_TABLE, new Ingredient[]{new Ingredient("clockworkheart", 1), new Ingredient("frozensoul", 1), new Ingredient("lifequartz", 25)}));
        Recipes.registerModRecipe((Recipe)new Recipe("perfectsoultrinket", 1, ModRecipeTechs.TRINKET_TABLE, new Ingredient[]{new Ingredient("clockworksoultrinket", 1), new Ingredient("lifependant", 1), new Ingredient("lifequartz", 50)}));
        Recipes.registerModRecipe((Recipe)new Recipe("cuirasstrinket", 1, ModRecipeTechs.TRINKET_TABLE, new Ingredient[]{new Ingredient("razorplatetrinket", 1), new Ingredient("sturdyplatetrinket", 1), new Ingredient("ancientfossilbar", 25)}));
        Recipes.registerModRecipe((Recipe)new Recipe("platemailtrinket", 1, ModRecipeTechs.TRINKET_TABLE, new Ingredient[]{new Ingredient("challengerspauldron", 1), new Ingredient("manica", 1), new Ingredient("cuirasstrinket", 1), new Ingredient("nightsteelbar", 25), new Ingredient("pearlescentdiamond", 10), new Ingredient("silk", 100)}));
    }

    public void Tools() {
        this.PaxelRecipe("woodpaxel", RecipeTechRegistry.WORKSTATION, "wood");
        this.PaxelRecipe("copperpaxel", RecipeTechRegistry.IRON_ANVIL, "copper");
        this.PaxelRecipe("ironpaxel", RecipeTechRegistry.IRON_ANVIL, "iron");
        this.PaxelRecipe("goldpaxel", RecipeTechRegistry.IRON_ANVIL, "gold");
        this.PaxelRecipe("frostpaxel", RecipeTechRegistry.IRON_ANVIL, "frost");
        this.PaxelRecipe("demonicpaxel", RecipeTechRegistry.DEMONIC_ANVIL, "demonic");
        this.PaxelRecipe("ivypaxel", RecipeTechRegistry.DEMONIC_ANVIL, "ivy");
        this.PaxelRecipe("tungstenpaxel", RecipeTechRegistry.TUNGSTEN_ANVIL, "tungsten");
        this.PaxelRecipe("glacialpaxel", RecipeTechRegistry.FALLEN_ANVIL, "glacial");
        this.PaxelRecipe("myceliumpaxel", RecipeTechRegistry.FALLEN_ANVIL, "mycelium");
        this.PaxelRecipe("ancientfossilpaxel", RecipeTechRegistry.FALLEN_ANVIL, "ancientfossil");
        Recipes.registerModRecipe((Recipe)new Recipe("gempaxel", 1, RecipeTechRegistry.FALLEN_ANVIL, new Ingredient[]{new Ingredient("gempickaxe", 1), new Ingredient("gemaxe", 1), new Ingredient("gemshovel", 1), new Ingredient("leather", 5)}).showBefore("icepickaxe"));
        this.GemToolRecipe("gempickaxe", "gempaxel");
        this.GemToolRecipe("gemaxe", "gempickaxe");
        this.GemToolRecipe("gemshovel", "gemaxe");
    }

    public void Potions() {
    }

    public void Misc() {
    }

    private void PaxelRecipe(String id, Tech tech, String tier) {
        Recipes.registerModRecipe((Recipe)new Recipe(id, 1, tech, new Ingredient[]{new Ingredient(tier + "pickaxe", 1), new Ingredient(tier + "axe", 1), new Ingredient(tier + "shovel", 1), new Ingredient("leather", 5)}).showBefore(tier + "pickaxe"));
    }

    private void GemToolRecipe(String id, String showBefore) {
        Recipes.registerModRecipe((Recipe)new Recipe(id, 1, RecipeTechRegistry.FALLEN_ANVIL, new Ingredient[]{new Ingredient("omnicrystal", 25), new Ingredient("pearlescentdiamond", 25), new Ingredient("amethyst", 10), new Ingredient("sapphire", 10), new Ingredient("ruby", 10), new Ingredient("emerald", 10)}).showAfter(showBefore));
    }

    private void TestRecipe(String id) {
        Recipes.registerModRecipe((Recipe)new Recipe(id, 1, RecipeTechRegistry.FALLEN_ANVIL, new Ingredient[]{new Ingredient("oaklog", 1)}));
    }

    private void Materials() {
        Recipes.registerModRecipe((Recipe)new Recipe("infinitiumbarmaterial", 1, ModRecipeTechs.TRINKET_TABLE, new Ingredient[]{new Ingredient("copperbar", 1), new Ingredient("demonicbar", 1), new Ingredient("glacialbar", 1), new Ingredient("goldbar", 1), new Ingredient("ironbar", 1), new Ingredient("ivybar", 1), new Ingredient("myceliumbar", 1), new Ingredient("nightsteelbar", 1), new Ingredient("spideritebar", 1), new Ingredient("tungstenbar", 1), new Ingredient("ancientfossilbar", 1)}));
    }

    private void CreateCategories() {
        for (String category : this.categories) {
            new ItemCategoryManager(ItemCategory.craftingMasterCategory).createCategory(category, new String[]{category});
        }
    }
}

