/*
 * Decompiled with CFR 0.152.
 */
package oddities.projectiles;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.GameDamage;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.projectile.Projectile;
import necesse.entity.trails.Trail;
import necesse.entity.trails.TrailVector;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;

public class MeowmereProjectile
extends Projectile {
    public Trail trail2;
    public Trail trail3;

    public MeowmereProjectile() {
        this.trail2 = new Trail((Projectile)this, this.getLevel(), new Color(0, 255, 4), 5.0f, 5, this.height);
        this.trail3 = new Trail((Projectile)this, this.getLevel(), new Color(255, 0, 0), 5.0f, 5, this.height);
    }

    public MeowmereProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float speed, int distance, GameDamage damage, int knockback) {
        this.trail2 = new Trail((Projectile)this, this.getLevel(), new Color(0, 255, 4), 5.0f, 5, this.height);
        this.trail3 = new Trail((Projectile)this, this.getLevel(), new Color(255, 0, 0), 5.0f, 5, this.height);
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.setTarget(targetX, targetY);
        this.speed = speed;
        this.distance = distance;
        this.setDamage(damage);
        this.knockback = knockback;
    }

    public void init() {
        super.init();
        this.givesLight = true;
        this.height = 18.0f;
        this.trailOffset = -14.0f;
        this.setWidth(16.0f, true);
        this.getLevel().entityManager.addTrail(this.trail2);
        this.getLevel().entityManager.addTrail(this.trail3);
    }

    public Color getParticleColor() {
        return new Color(5, 171, 0);
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(18, 94, 0), 1.0f, 100, this.getHeight());
    }

    public void moveDist(double dist) {
        super.moveDist(dist);
        if (this.trail != null) {
            this.trail2.addPoint(new TrailVector(this.x + this.dx * this.trailOffset + 10.0f, this.y + this.dy * this.trailOffset + 10.0f, this.dx, this.dy, this.getTrailThickness(), this.getHeight()));
            this.trail3.addPoint(new TrailVector(this.x + this.dx * this.trailOffset - 10.0f, this.y + this.dy * this.trailOffset - 10.0f, this.dx, this.dy, this.getTrailThickness(), this.getHeight()));
        }
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (this.removed()) {
            return;
        }
        GameLight light = level.getLightLevel((Entity)this);
        int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
        int drawY = camera.getDrawY(this.y);
        TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.getAngle(), this.texture.getWidth() / 2, 2).pos(drawX, drawY - (int)this.getHeight());
        list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
            final /* synthetic */ TextureDrawOptions val$options;
            {
                this.val$options = textureDrawOptions;
                super(arg0);
            }

            public void draw(TickManager tickManager) {
                this.val$options.draw();
            }
        });
        this.addShadowDrawables(tileList, drawX, drawY, light, this.getAngle(), this.texture.getWidth() / 2, 2);
    }

    public void doHitLogic(Mob mob, LevelObjectHit object, float x, float y) {
        super.doHitLogic(mob, object, x, y);
        if (this.isServer() && mob != null) {
            mob.addBuff(new ActiveBuff("venombuff", mob, 10.0f, (Attacker)this.getOwner()), true);
        }
    }
}

