/*
 * Decompiled with CFR 0.152.
 */
package oddities.projectiles;

import java.awt.Color;
import java.util.List;
import necesse.engine.gameLoop.tickManager.TickManager;
import necesse.engine.network.server.ServerClient;
import necesse.entity.Entity;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.followingProjectile.FollowingProjectile;
import necesse.entity.trails.Trail;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.texture.TextureDrawOptions;
import necesse.gfx.drawOptions.texture.TextureDrawOptionsEnd;
import necesse.gfx.drawables.EntityDrawable;
import necesse.gfx.drawables.LevelSortedDrawable;
import necesse.gfx.drawables.OrderableDrawables;
import necesse.level.maps.Level;
import necesse.level.maps.LevelObjectHit;
import necesse.level.maps.light.GameLight;
import oddities.utility.Mathx;

public class ManaGainProjectile
extends FollowingProjectile {
    private float manaGain = 0.0f;

    public ManaGainProjectile() {
    }

    public ManaGainProjectile(Level level, Mob owner, float x, float y, float targetX, float targetY, float manaGain) {
        System.out.println("spawned projectile");
        this.setLevel(level);
        this.setOwner(owner);
        this.x = x;
        this.y = y;
        this.speed = 100.0f;
        this.distance = 100000;
        this.knockback = 0;
        this.setTarget(targetX, targetY);
        this.manaGain = manaGain;
        this.returningToOwner = true;
        this.turnSpeed = 0.9f;
        this.givesLight = true;
        this.piercing = 100;
        this.bouncing = 2;
        this.isSolid = false;
    }

    protected int getExtraSpinningParticles() {
        return super.getExtraSpinningParticles() + 1;
    }

    public Color getParticleColor() {
        return new Color(0, 25, 127);
    }

    public Trail getTrail() {
        return new Trail((Projectile)this, this.getLevel(), new Color(0, 69, 166), 6.0f, 500, 18.0f);
    }

    public void updateTarget() {
        if (this.traveledDistance > 0.0f) {
            System.out.println("updating target");
            this.findTarget(m -> m.isPlayer, 1600.0f, 16000.0f);
        }
    }

    public void addDrawables(List<LevelSortedDrawable> list, OrderableDrawables tileList, OrderableDrawables topList, OrderableDrawables overlayList, Level level, TickManager tickManager, GameCamera camera, PlayerMob perspective) {
        if (!this.removed()) {
            GameLight light = level.getLightLevel((Entity)this);
            int drawX = camera.getDrawX(this.x) - this.texture.getWidth() / 2;
            int drawY = camera.getDrawY(this.y);
            TextureDrawOptionsEnd options = this.texture.initDraw().light(light).rotate(this.getAngle(), this.texture.getWidth() / 2, 0).pos(drawX, drawY - (int)this.getHeight());
            list.add((LevelSortedDrawable)new EntityDrawable((Entity)this, (TextureDrawOptions)options){
                final /* synthetic */ TextureDrawOptions val$options;
                {
                    this.val$options = textureDrawOptions;
                    super(arg0);
                }

                public void draw(TickManager tickManager) {
                    this.val$options.draw();
                }
            });
            this.addShadowDrawables(tileList, drawX, drawY, light, this.getAngle(), 0);
        }
    }

    public void onHit(Mob mob, LevelObjectHit object, float x, float y, boolean fromPacket, ServerClient packetSubmitter) {
        System.out.println("hit something");
        if (mob instanceof PlayerMob) {
            PlayerMob player = (PlayerMob)mob;
            System.out.println("hit player");
            player.setMana(Mathx.clamp(this.manaGain, player.getMana() + this.manaGain, (float)player.getMaxMana()));
            super.onHit(mob, object, x, y, fromPacket, packetSubmitter);
        } else {
            System.out.println("hit something else");
        }
    }
}

