/*
 * Decompiled with CFR 0.152.
 */
package oddities.items.weapons.ranged;

import java.awt.Color;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.arrowItem.ArrowItem;
import necesse.inventory.item.toolItem.projectileToolItem.bowProjectileToolItem.greatbowProjectileToolItem.GreatbowProjectileToolItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.level.maps.Level;

public class PiercingFloodWeapon
extends GreatbowProjectileToolItem {
    public PiercingFloodWeapon(int enchantCost) {
        super(enchantCost, new OneOfLootItems(new LootItemInterface[0]));
    }

    public PiercingFloodWeapon() {
        this(5000);
        this.rarity = Item.Rarity.LEGENDARY;
        this.attackAnimTime.setBaseValue(1500);
        this.attackDamage.setBaseValue(40.0f).setUpgradedValue(1.0f, 70.0f);
        this.attackRange.setBaseValue(800);
        this.velocity.setBaseValue(450);
        this.attackXOffset = 10;
        this.attackYOffset = 34;
        this.particleColor = new Color(0, 140, 255);
    }

    protected void fireProjectiles(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item, int seed, ArrowItem arrow, boolean dropItem, GNDItemMap mapContent) {
        GameRandom random = new GameRandom((long)seed);
        GameRandom spreadRandom = random.nextSeeded(27);
        int i = 0;
        while ((float)i <= 3.0f + this.getUpgradeTier(item) * 2.0f) {
            Projectile projectile = this.getProjectile(level, x, y, attackerMob, item, seed, arrow, dropItem, mapContent);
            projectile.piercing = (int)this.getUpgradeTier(item);
            projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item)));
            projectile.dropItem = false;
            projectile.getUniqueID(new GameRandom((long)seed));
            level.entityManager.projectiles.addHidden((Entity)projectile);
            if (this.moveDist != 0) {
                projectile.moveDist((double)this.moveDist);
            }
            projectile.setAngle(projectile.getAngle() + (spreadRandom.nextFloat() - 0.5f) * 25.0f);
            ++i;
        }
    }
}

