/*
 * Decompiled with CFR 0.152.
 */
package oddities.items.weapons.melee;

import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.inventory.InventoryItem;
import necesse.inventory.enchants.ToolItemModifiers;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.meleeProjectileToolItem.MeleeProjectileToolItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.level.maps.Level;
import oddities.projectiles.ManaStealProjectileThree;
import oddities.utility.Mathx;

public class ManaStealWeaponThree
extends MeleeProjectileToolItem {
    private static final float manaRegen = 2000.0f;

    public ManaStealWeaponThree() {
        super(400, new OneOfLootItems(new LootItemInterface[0]));
        this.rarity = Item.Rarity.UNCOMMON;
        this.attackAnimTime.setBaseValue(350);
        this.attackDamage.setBaseValue(35.0f).setUpgradedValue(1.0f, 43.0f);
        this.attackRange.setBaseValue(80);
        this.knockback.setBaseValue(60);
        this.resilienceGain.setBaseValue(1.0f);
    }

    public void tickHolding(InventoryItem item, PlayerMob player) {
        super.tickHolding(item, player);
        player.setMana(player.getMana() + (float)player.getMaxMana() / 2000.0f);
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        if (this.getAnimInverted(item)) {
            drawOptions.swingRotationInv(attackProgress);
        } else {
            drawOptions.swingRotation(attackProgress);
        }
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.swing2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        item = super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
        float rangeMod = 7.0f;
        float velocity = 140.0f;
        float finalVelocity = Math.round(((Float)this.getEnchantment(item).applyModifierLimited(ToolItemModifiers.VELOCITY, (Object)((Float)ToolItemModifiers.VELOCITY.defaultBuffManagerValue))).floatValue() * velocity * ((Float)attackerMob.buffManager.getModifier(BuffModifiers.PROJECTILE_VELOCITY)).floatValue());
        GameRandom random = new GameRandom((long)seed);
        for (int i = -1; i <= 1; ++i) {
            ManaStealProjectileThree projectile = new ManaStealProjectileThree(level, (Mob)attackerMob, attackerMob.x, attackerMob.y, x, y, finalVelocity, this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)attackerMob));
            projectile.resetUniqueID(random);
            attackerMob.addAndSendAttackerProjectile((Projectile)projectile, 20, (float)(5 * i));
        }
        return item;
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        super.hitMob(item, event, level, target, attacker);
        if (attacker instanceof PlayerMob) {
            PlayerMob player = (PlayerMob)attacker;
            if (target != null) {
                player.setMana(Mathx.clamp(this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue(), player.getMana() + this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue() / 3.0f, (float)player.getMaxMana()));
            }
        }
    }
}

