/*
 * Decompiled with CFR 0.152.
 */
package oddities.items.weapons.melee;

import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.meleeProjectileToolItem.MeleeProjectileToolItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.level.maps.Level;
import oddities.projectiles.ManaStealProjectileOne;
import oddities.utility.Mathx;

public class ManaStealWeaponOne
extends MeleeProjectileToolItem {
    private static final float manaRegen = 8000.0f;

    public ManaStealWeaponOne() {
        super(400, new OneOfLootItems(new LootItemInterface[0]));
        this.rarity = Item.Rarity.UNCOMMON;
        this.attackAnimTime.setBaseValue(450);
        this.attackDamage.setBaseValue(11.0f).setUpgradedValue(1.0f, 15.0f);
        this.attackRange.setBaseValue(60);
        this.velocity.setBaseValue(60);
        this.knockback.setBaseValue(60);
        this.resilienceGain.setBaseValue(0.1f);
    }

    public void tickHolding(InventoryItem item, PlayerMob player) {
        super.tickHolding(item, player);
        player.setMana(player.getMana() + (float)player.getMaxMana() / 8000.0f);
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        if (this.getAnimInverted(item)) {
            drawOptions.swingRotationInv(attackProgress);
        } else {
            drawOptions.swingRotation(attackProgress);
        }
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.swing2, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        ManaStealProjectileOne projectile = new ManaStealProjectileOne(level, (Mob)attackerMob, attackerMob.x, attackerMob.y, x, y, this.getProjectileVelocity(item, (Mob)attackerMob), this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)attackerMob));
        projectile.resetUniqueID(new GameRandom((long)seed));
        attackerMob.addAndSendAttackerProjectile((Projectile)projectile);
        return item;
    }

    public boolean canHitMob(Mob mob, ToolItemMobAbilityEvent event) {
        return !(mob instanceof PlayerMob);
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        super.hitMob(item, event, level, target, attacker);
        if (attacker instanceof PlayerMob) {
            PlayerMob player = (PlayerMob)attacker;
            if (target != null) {
                player.setMana(Mathx.clamp(this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue(), player.getMana() + this.attackDamage.getValue(this.getUpgradeTier(item)).floatValue() / 2.0f, (float)player.getMaxMana()));
            }
        }
    }
}

