/*
 * Decompiled with CFR 0.152.
 */
package oddities.items.weapons.melee;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.LinkedList;
import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.registries.BuffRegistry;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameMath;
import necesse.engine.util.GameRandom;
import necesse.entity.levelEvent.LevelEvent;
import necesse.entity.levelEvent.SwordCleanSliceAttackEvent;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.AttackAnimMob;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.AttackHandler;
import necesse.entity.mobs.buffs.ActiveBuff;
import necesse.entity.mobs.buffs.BuffModifiers;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.entity.projectile.modifiers.ProjectileModifier;
import necesse.entity.projectile.modifiers.ResilienceOnHitProjectileModifier;
import necesse.entity.trails.Trail;
import necesse.entity.trails.TrailVector;
import necesse.gfx.GameResources;
import necesse.gfx.camera.GameCamera;
import necesse.gfx.drawOptions.DrawOptions;
import necesse.gfx.drawOptions.itemAttack.ItemAttackDrawOptions;
import necesse.gfx.gameTexture.GameSprite;
import necesse.gfx.gameTexture.GameTexture;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.enchants.ToolItemModifiers;
import necesse.inventory.item.Item;
import necesse.inventory.item.ItemControllerInteract;
import necesse.inventory.item.ItemInteractAction;
import necesse.inventory.item.toolItem.swordToolItem.SwordToolItem;
import necesse.inventory.item.upgradeUtils.IntUpgradeValue;
import necesse.inventory.item.upgradeUtils.UpgradedItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.inventory.recipe.Ingredient;
import necesse.level.maps.Level;
import oddities.items.weapons.melee.extras.ImbuedKatanaDashAttackHandler;
import oddities.projectiles.KatanaWaveProjectile;

public class ImbuedKatanaWeapon
extends SwordToolItem
implements ItemInteractAction {
    public IntUpgradeValue maxDashStacks = new IntUpgradeValue(10, 0.0f);
    public IntUpgradeValue dashRange = new IntUpgradeValue(300, 0.0f);
    public GameTexture invertedAttackTexture;

    public ImbuedKatanaWeapon(int enchantCost) {
        super(enchantCost, new OneOfLootItems(new LootItemInterface[0]));
    }

    public ImbuedKatanaWeapon() {
        this(5000);
        this.rarity = Item.Rarity.LEGENDARY;
        this.attackAnimTime.setBaseValue(200).setUpgradedValue(5.0f, 150);
        this.attackDamage.setBaseValue(50.0f).setUpgradedValue(1.0f, 60.0f).setUpgradedValue(2.0f, 85.0f).setUpgradedValue(3.0f, 110.0f).setUpgradedValue(4.0f, 135.0f).setUpgradedValue(5.0f, 160.0f);
        this.attackRange.setBaseValue(100);
        this.knockback.setBaseValue(75);
        this.resilienceGain.setBaseValue(1.3f);
        this.maxDashStacks.setBaseValue(10).setUpgradedValue(5.0f, 25);
        this.dashRange.setBaseValue(300);
        this.attackXOffset = 4;
        this.attackYOffset = 4;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"katanasecondarytip", (String)"stacks", (Object)this.maxDashStacks.getValue(this.getUpgradeTier(item))), 400);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"katanaprimarytip"), 400);
        return tooltips;
    }

    public UpgradedItem getUpgradedItem(InventoryItem item) {
        int nextTier = this.getNextUpgradeTier(item);
        InventoryItem upgradedItem = item.copy();
        upgradedItem.item.setUpgradeTier(upgradedItem, (float)nextTier);
        int cost = nextTier <= 1 ? Math.max((int)((1.0f - this.getTier1CostPercent(item)) * 40.0f), 1) : nextTier * 20;
        return new UpgradedItem(item, upgradedItem, new Ingredient[]{new Ingredient("upgradeshard", cost * 5)});
    }

    protected void loadAttackTexture() {
        super.loadAttackTexture();
        try {
            this.invertedAttackTexture = GameTexture.fromFileRaw((String)("player/weapons/" + this.getStringID() + "_inverted"));
        }
        catch (FileNotFoundException var2) {
            this.invertedAttackTexture = null;
        }
    }

    public ItemAttackDrawOptions setupItemSpriteAttackDrawOptions(ItemAttackDrawOptions options, InventoryItem item, PlayerMob player, int mobDir, float attackDirX, float attackDirY, float attackProgress, Color itemColor) {
        if (item.getGndData().getBoolean("chargeUp")) {
            float chargePercent = Math.min(item.getGndData().getFloat("chargePercent"), 1.0f);
            ItemAttackDrawOptions.AttackItemSprite itemSprite = options.itemSprite(this.getAttackSprite(item, player));
            if (options.dir == 0) {
                itemSprite.itemRotateOffsetAdd(GameMath.lerp((float)chargePercent, (float)70.0f, (float)90.0f));
                itemSprite.itemRotatePoint(this.attackXOffset + GameMath.lerp((float)chargePercent, (int)16, (int)18), this.attackYOffset - GameMath.lerp((float)chargePercent, (int)0, (int)4));
            } else if (options.dir == 2) {
                itemSprite.itemRotateOffsetAdd(GameMath.lerp((float)chargePercent, (float)150.0f, (float)170.0f));
                itemSprite.itemRotatePoint(this.attackXOffset + GameMath.lerp((float)chargePercent, (int)22, (int)26), this.attackYOffset);
            } else {
                itemSprite.itemRotateOffsetAdd(GameMath.lerp((float)chargePercent, (float)120.0f, (float)140.0f));
                itemSprite.itemRotatePoint(this.attackXOffset + GameMath.lerp((float)chargePercent, (int)20, (int)22), this.attackYOffset);
            }
            if (itemColor != null) {
                itemSprite.itemColor(itemColor);
            }
            return itemSprite.itemEnd();
        }
        if (item.getGndData().getBoolean("sliceDash")) {
            ItemAttackDrawOptions.AttackItemSprite itemSprite = options.itemSprite(this.getAttackSprite(item, player));
            if (options.dir == 0) {
                itemSprite.itemRotateOffsetAdd(90.0f);
                itemSprite.itemRotatePoint(this.attackXOffset + 18, this.attackYOffset - 4);
            } else if (options.dir == 2) {
                itemSprite.itemRotateOffsetAdd(170.0f);
                itemSprite.itemRotatePoint(this.attackXOffset + 26, this.attackYOffset);
            } else {
                itemSprite.itemRotateOffsetAdd(140.0f);
                itemSprite.itemRotatePoint(this.attackXOffset + 22, this.attackYOffset);
            }
            if (itemColor != null) {
                itemSprite.itemColor(itemColor);
            }
            return itemSprite.itemEnd();
        }
        return super.setupItemSpriteAttackDrawOptions(options, item, player, mobDir, attackDirX, attackDirY, attackProgress, itemColor);
    }

    public void setDrawAttackRotation(InventoryItem item, ItemAttackDrawOptions drawOptions, float attackDirX, float attackDirY, float attackProgress) {
        if (item.getGndData().getBoolean("chargeUp")) {
            float chargePercent = Math.min(item.getGndData().getFloat("chargePercent"), 1.0f);
            if (drawOptions.dir == 2) {
                drawOptions.rotation(GameMath.lerp((float)chargePercent, (float)-20.0f, (float)0.0f));
            } else {
                drawOptions.rotation(GameMath.lerp((float)chargePercent, (float)80.0f, (float)100.0f));
            }
        } else if (item.getGndData().getBoolean("sliceDash")) {
            if (drawOptions.dir == 2) {
                drawOptions.rotation(GameMath.lerp((float)attackProgress, (float)0.0f, (float)-270.0f));
            } else {
                drawOptions.rotation(GameMath.lerp((float)attackProgress, (float)100.0f, (float)-170.0f));
            }
        } else {
            super.setDrawAttackRotation(item, drawOptions, attackDirX, attackDirY, attackProgress);
        }
    }

    public float getSwingRotationAngle(InventoryItem item, int dir) {
        if (item.getGndData().getBoolean("chargeUp")) {
            return 150.0f;
        }
        return item.getGndData().getBoolean("sliceDash") ? 150.0f : 150.0f;
    }

    public float getSwingRotationOffset(InventoryItem item, int dir, float swingAngle) {
        float offset = super.getSwingRotationOffset(item, dir, swingAngle);
        if (item.getGndData().getBoolean("chargeUp")) {
            return offset;
        }
        if (item.getGndData().getBoolean("sliceDash")) {
            return offset;
        }
        return item.getGndData().getBoolean("slash") ? offset : offset - 40.0f;
    }

    public float getHitboxSwingAngle(InventoryItem item, int dir) {
        if (item.getGndData().getBoolean("chargeUp")) {
            return 150.0f;
        }
        return item.getGndData().getBoolean("sliceDash") ? 150.0f : 150.0f;
    }

    public float getHitboxSwingAngleOffset(InventoryItem item, int dir, float swingAngle) {
        if (item.getGndData().getBoolean("chargeUp")) {
            return 0.0f;
        }
        if (item.getGndData().getBoolean("sliceDash")) {
            return 0.0f;
        }
        return item.getGndData().getBoolean("slash") ? 0.0f : -40.0f;
    }

    public boolean animDrawBehindHand(InventoryItem item) {
        return item.getGndData().getBoolean("chargeUp") ? true : super.animDrawBehindHand(item);
    }

    public boolean getAnimInverted(InventoryItem item) {
        return item.getGndData().getBoolean("slash") || item.getGndData().getBoolean("sliceDash");
    }

    public GameSprite getAttackSprite(InventoryItem item, PlayerMob player) {
        return (this.getAnimInverted(item) || item.getGndData().getBoolean("chargeUp") || item.getGndData().getBoolean("sliceDash")) && this.invertedAttackTexture != null ? new GameSprite(this.invertedAttackTexture) : super.getAttackSprite(item, player);
    }

    public void showKatanaAttack(Level level, final AttackAnimMob mob, final int seed, final InventoryItem item) {
        level.entityManager.addLevelEventHidden((LevelEvent)new SwordCleanSliceAttackEvent(mob, seed, 12, this){
            Trail[] trails;
            final float maxTrailThickness = 25.0f;
            final float minTrailThickness = 10.0f;
            {
                super(arg0, arg1, arg2, arg3);
                this.trails = null;
                this.maxTrailThickness = 25.0f;
                this.minTrailThickness = 10.0f;
            }

            public void tick(float angle, float currentAttackProgress) {
                int sliceDirOffset;
                int attackRange = ImbuedKatanaWeapon.this.getAttackRange(item);
                Point2D.Float base = new Point2D.Float(mob.x, mob.y);
                int attackDir = mob.getDir();
                if (attackDir == 0) {
                    base.x += 8.0f;
                } else if (attackDir == 2) {
                    base.x -= 8.0f;
                }
                int minTrailRange = 60;
                int distancePerTrail = 5;
                boolean strictTrailAngles = item.getGndData().getBoolean("sliceDash");
                if (strictTrailAngles) {
                    attackRange -= 20;
                    minTrailRange -= 20;
                    angle = ((Float)ImbuedKatanaWeapon.this.getSwingDirection(item, mob).apply(Float.valueOf(currentAttackProgress))).floatValue();
                } else {
                    angle = ((Float)ImbuedKatanaWeapon.this.getSwingDirection(item, mob).apply(Float.valueOf(currentAttackProgress))).floatValue();
                }
                Point2D.Float dir = GameMath.getAngleDir((float)angle);
                int n = sliceDirOffset = ImbuedKatanaWeapon.this.getAnimInverted(item) ? -90 : 90;
                if (attackDir == 3) {
                    sliceDirOffset = -sliceDirOffset;
                }
                Point2D.Float sliceDir = GameMath.getAngleDir((float)(angle + (float)sliceDirOffset));
                if (this.trails == null) {
                    int i = strictTrailAngles ? 1000 : 500;
                    int trailCount = Math.max(1, (attackRange - minTrailRange - 10) / distancePerTrail);
                    this.trails = new Trail[trailCount];
                    for (int ix = 0; ix < this.trails.length; ++ix) {
                        Trail trail;
                        this.trails[ix] = trail = new Trail(this.getVector(currentAttackProgress, attackRange, ix, distancePerTrail, base, dir, sliceDir), this.level, new Color(182, 218, 220), i);
                        trail.removeOnFadeOut = false;
                        trail.sprite = new GameSprite(GameResources.chains, 7, 0, 32);
                        this.level.entityManager.addTrail(trail);
                    }
                } else {
                    for (int i = 0; i < this.trails.length; ++i) {
                        if (strictTrailAngles) {
                            this.trails[i].addPointIfSameDirection(this.getVector(currentAttackProgress, attackRange, i, distancePerTrail, base, dir, sliceDir), 0.2f, 20.0f, 50.0f);
                            continue;
                        }
                        this.trails[i].addPoint(this.getVector(currentAttackProgress, attackRange, i, distancePerTrail, base, dir, sliceDir));
                    }
                }
            }

            public TrailVector getVector(float currentAttackProgress, int attackRange, int index, int distancePerTrail, Point2D.Float base, Point2D.Float dir, Point2D.Float sliceDir) {
                float thickness = GameMath.lerp((float)((float)index / (float)(this.trails.length - 1)), (float)25.0f, (float)10.0f);
                if (currentAttackProgress < 0.33f) {
                    thickness *= 3.0f * currentAttackProgress;
                } else if (currentAttackProgress > 0.66f) {
                    thickness *= 3.0f * (1.0f - currentAttackProgress);
                }
                int distanceOffset = attackRange - index * distancePerTrail;
                GameRandom random = new GameRandom((long)seed).nextSeeded(index + 5);
                float xOffset = random.getFloatOffset(0.0f, 10.0f);
                float yOffset = random.getFloatOffset(0.0f, 10.0f);
                Point2D.Float edgePos = new Point2D.Float(base.x + dir.x * (float)distanceOffset + xOffset, base.y + dir.y * (float)distanceOffset + yOffset);
                return new TrailVector(edgePos.x, edgePos.y, sliceDir.x, sliceDir.y, thickness, 0.0f);
            }

            public void onDispose() {
                super.onDispose();
                if (this.trails != null) {
                    for (Trail trail : this.trails) {
                        trail.removeOnFadeOut = true;
                    }
                }
            }
        });
    }

    public int getFlatItemCooldownTime(InventoryItem item) {
        if (!item.getGndData().getBoolean("chargeUp") && !item.getGndData().getBoolean("sliceDash")) {
            return item.getGndData().getBoolean("slash") ? (int)((float)this.getFlatAttackAnimTime(item) * 2.5f) : super.getFlatItemCooldownTime(item);
        }
        return 0;
    }

    public boolean canItemAttackerHitTarget(ItemAttackerMob attackerMob, float fromX, float fromY, Mob target, InventoryItem item) {
        return this.itemAttackerHasLineOfSightToTarget(attackerMob, fromX, fromY, target, 5.0f);
    }

    public int getItemAttackerAttackRange(ItemAttackerMob mob, InventoryItem item) {
        return !mob.isPlayer && this.canDash(mob) ? (int)((float)this.dashRange.getValue(this.getUpgradeTier(item)).intValue() * 0.8f) : super.getItemAttackerAttackRange(mob, item);
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (!item.getGndData().getBoolean("chargeUp")) {
            super.showAttack(level, x, y, attackerMob, attackHeight, item, 1, seed, mapContent);
            if (level.isClient()) {
                this.showKatanaAttack(level, (AttackAnimMob)attackerMob, seed, item);
            }
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        if (!attackerMob.isPlayer && this.canDash(attackerMob)) {
            float stacksPercent = (float)attackerMob.buffManager.getStacks(BuffRegistry.KATANA_DASH_STACKS) / (float)this.maxDashStacks.getValue(this.getUpgradeTier(item)).intValue();
            float animModifier = GameMath.lerp((double)Math.min(Math.pow(stacksPercent * 2.0f, 0.5), 1.0), (long)8L, (long)1L);
            int animTime = (int)((float)this.getAttackAnimTime(item, attackerMob) * animModifier);
            mapContent.setBoolean("chargeUp", true);
            attackerMob.startAttackHandler((AttackHandler)new ImbuedKatanaDashAttackHandler(attackerMob, slot, item, this, animTime, new Color(190, 220, 220), seed));
            return item;
        }
        float rangeMod = 7.0f;
        float velocity = 140.0f;
        float finalVelocity = Math.round(((Float)this.getEnchantment(item).applyModifierLimited(ToolItemModifiers.VELOCITY, (Object)((Float)ToolItemModifiers.VELOCITY.defaultBuffManagerValue))).floatValue() * velocity * ((Float)attackerMob.buffManager.getModifier(BuffModifiers.PROJECTILE_VELOCITY)).floatValue());
        KatanaWaveProjectile projectile = new KatanaWaveProjectile(level, attackerMob.x, attackerMob.y, x, y, finalVelocity, (int)((float)this.getAttackRange(item) * rangeMod), this.getAttackDamage(item), (Mob)attackerMob);
        projectile.setModifier((ProjectileModifier)new ResilienceOnHitProjectileModifier(this.getResilienceGain(item) / 2.0f));
        attackerMob.addAndSendAttackerProjectile((Projectile)projectile, 20, 0.0f);
        boolean isSlash = item.getGndData().getBoolean("slash");
        item.getGndData().setBoolean("slash", !isSlash);
        item.getGndData().setBoolean("chargeUp", false);
        item.getGndData().setBoolean("sliceDash", false);
        if (animAttack == 0) {
            int animTime = this.getAttackAnimTime(item, attackerMob);
            ToolItemMobAbilityEvent event = new ToolItemMobAbilityEvent((AttackAnimMob)attackerMob, seed, item, x - attackerMob.getX(), y - attackerMob.getY() + attackHeight, animTime, animTime, isSlash ? new HashMap() : null);
            attackerMob.addAndSendAttackerLevelEvent((LevelEvent)event);
        }
        return item;
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        super.hitMob(item, event, level, target, attacker);
        if (event.totalHits == 0) {
            attacker.buffManager.removeStack(BuffRegistry.KATANA_DASH_STACKS, true, level.isServer());
        }
        target.buffManager.addBuff(new ActiveBuff(BuffRegistry.Debuffs.HAUNTED, target, 2000, (Attacker)attacker), true);
    }

    public boolean canLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, InventoryItem item) {
        return this.canDash(attackerMob);
    }

    public boolean canDash(ItemAttackerMob attackerMob) {
        return !attackerMob.isRiding() && !attackerMob.buffManager.hasBuff(BuffRegistry.Debuffs.KATANA_DASH_COOLDOWN);
    }

    public int getLevelInteractCooldownTime(InventoryItem item, ItemAttackerMob attackerMob) {
        return 0;
    }

    public boolean getConstantInteract(InventoryItem item) {
        return true;
    }

    public InventoryItem onLevelInteract(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int seed, GNDItemMap mapContent) {
        float stacksPercent = (float)attackerMob.buffManager.getStacks(BuffRegistry.KATANA_DASH_STACKS) / (float)this.maxDashStacks.getValue(this.getUpgradeTier(item)).intValue();
        float animModifier = GameMath.lerp((double)Math.min(Math.pow(stacksPercent * 2.0f, 0.5), 1.0), (long)8L, (long)1L);
        int animTime = (int)((float)this.getAttackAnimTime(item, attackerMob) * animModifier);
        mapContent.setBoolean("chargeUp", true);
        attackerMob.startAttackHandler(new ImbuedKatanaDashAttackHandler(attackerMob, slot, item, this, animTime, new Color(190, 220, 220), seed).startFromInteract());
        return item;
    }

    public ItemControllerInteract getControllerInteract(Level level, PlayerMob player, InventoryItem item, boolean beforeObjectInteract, int interactDir, LinkedList<Rectangle> mobInteractBoxes, LinkedList<Rectangle> tileInteractBoxes) {
        Point2D.Float controllerAimDir = player.getControllerAimDir();
        Point levelPos = this.getControllerAttackLevelPos(level, controllerAimDir.x, controllerAimDir.y, player, item);
        return new ItemControllerInteract(levelPos.x, levelPos.y){

            public DrawOptions getDrawOptions(GameCamera camera) {
                return null;
            }

            public void onCurrentlyFocused(GameCamera camera) {
            }
        };
    }
}

