/*
 * Decompiled with CFR 0.152.
 */
package oddities.items.weapons.melee;

import necesse.engine.localization.Localization;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.util.GameBlackboard;
import necesse.entity.levelEvent.mobAbilityLevelEvent.ToolItemMobAbilityEvent;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.attackHandler.GreatswordAttackHandler;
import necesse.entity.mobs.attackHandler.GreatswordChargeLevel;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.swordToolItem.greatswordToolItem.GreatswordToolItem;
import necesse.inventory.item.upgradeUtils.UpgradedItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.inventory.recipe.Ingredient;
import necesse.level.maps.Level;

public class GiantSlayerWeapon
extends GreatswordToolItem {
    private GreatswordAttackHandler handler;

    public GiantSlayerWeapon() {
        super(2500, new OneOfLootItems(new LootItemInterface[0]), GiantSlayerWeapon.getThreeChargeLevels((int)750, (int)1000, (int)1250));
        this.rarity = Item.Rarity.LEGENDARY;
        this.attackDamage.setBaseValue(1.0f).setUpgradedValue(1.0f, 1.0f);
        this.attackRange.setBaseValue(135);
        this.knockback.setBaseValue(300);
        this.resilienceGain.setBaseValue(0.0f);
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        this.handler = new GreatswordAttackHandler(attackerMob, slot, item, (GreatswordToolItem)this, seed, x, y, this.chargeLevels);
        return super.onAttack(level, x, y, attackerMob, attackHeight, item, slot, animAttack, seed, mapContent);
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"giantslayerweapontip"), 400);
        return tooltips;
    }

    public void hitMob(InventoryItem item, ToolItemMobAbilityEvent event, Level level, Mob target, Mob attacker) {
        for (GreatswordChargeLevel chargeLevel : this.chargeLevels) {
            chargeLevel.damageModifier = 1.0f;
        }
        if ((double)this.handler.getChargePercent() >= 1.0) {
            target.setHealth((int)((float)target.getHealth() - (float)target.getMaxHealthFlat() / this.getDamageForLevel(item)));
        }
        super.hitMob(item, event, level, target, attacker);
        this.attackDamage.setBaseValue(1.0f);
    }

    private float getDamageForLevel(InventoryItem item) {
        float damage = 0.0f;
        float tier = this.getUpgradeTier(item);
        switch ((int)tier) {
            case 1: {
                damage = 13.0f;
                break;
            }
            case 2: {
                damage = 11.0f;
                break;
            }
            case 3: {
                damage = 9.0f;
                break;
            }
            case 4: {
                damage = 7.0f;
                break;
            }
            case 5: {
                damage = 5.0f;
                break;
            }
            default: {
                damage = 15.0f;
            }
        }
        return damage;
    }

    public UpgradedItem getUpgradedItem(InventoryItem item) {
        int nextTier = this.getNextUpgradeTier(item);
        InventoryItem upgradedItem = item.copy();
        upgradedItem.item.setUpgradeTier(upgradedItem, (float)nextTier);
        int cost = nextTier <= 1 ? Math.max((int)((1.0f - this.getTier1CostPercent(item)) * 40.0f), 1) : nextTier * 50;
        return new UpgradedItem(item, upgradedItem, new Ingredient[]{new Ingredient("upgradeshard", cost * 5)});
    }
}

