/*
 * Decompiled with CFR 0.152.
 */
package oddities.items.weapons.magic;

import necesse.engine.localization.Localization;
import necesse.engine.network.Packet;
import necesse.engine.network.gameNetworkData.GNDItemMap;
import necesse.engine.network.packet.PacketSpawnProjectile;
import necesse.engine.sound.PrimitiveSoundEmitter;
import necesse.engine.sound.SoundEffect;
import necesse.engine.sound.SoundManager;
import necesse.engine.sound.gameSound.GameSound;
import necesse.engine.util.GameBlackboard;
import necesse.engine.util.GameRandom;
import necesse.entity.Entity;
import necesse.entity.mobs.Attacker;
import necesse.entity.mobs.Mob;
import necesse.entity.mobs.PlayerMob;
import necesse.entity.mobs.itemAttacker.ItemAttackSlot;
import necesse.entity.mobs.itemAttacker.ItemAttackerMob;
import necesse.entity.projectile.Projectile;
import necesse.gfx.GameResources;
import necesse.gfx.gameTooltips.ListGameTooltips;
import necesse.inventory.InventoryItem;
import necesse.inventory.item.Item;
import necesse.inventory.item.toolItem.projectileToolItem.magicProjectileToolItem.MagicProjectileToolItem;
import necesse.inventory.lootTable.LootItemInterface;
import necesse.inventory.lootTable.lootItem.OneOfLootItems;
import necesse.level.maps.Level;
import necesse.level.maps.regionSystem.RegionPositionGetter;
import oddities.projectiles.WaterBoltProjectile;

public class WaterBoltWeapon
extends MagicProjectileToolItem {
    public WaterBoltWeapon() {
        super(400, new OneOfLootItems(new LootItemInterface[0]));
        this.rarity = Item.Rarity.EPIC;
        this.attackAnimTime.setBaseValue(150);
        this.attackDamage.setBaseValue(20.0f).setUpgradedValue(1.0f, 30.0f).setUpgradedValue(2.0f, 40.0f).setUpgradedValue(3.0f, 50.0f).setUpgradedValue(4.0f, 60.0f).setUpgradedValue(5.0f, 75.0f);
        this.velocity.setBaseValue(40);
        this.knockback.setBaseValue(5);
        this.attackRange.setBaseValue(1500);
        this.manaCost.setBaseValue(3.5f).setUpgradedValue(1.0f, 3.0f).setUpgradedValue(2.0f, 2.5f).setUpgradedValue(3.0f, 2.0f).setUpgradedValue(4.0f, 1.5f).setUpgradedValue(5.0f, 1.0f);
        this.attackXOffset = 12;
        this.attackYOffset = 22;
    }

    public ListGameTooltips getPreEnchantmentTooltips(InventoryItem item, PlayerMob perspective, GameBlackboard blackboard) {
        ListGameTooltips tooltips = super.getPreEnchantmentTooltips(item, perspective, blackboard);
        tooltips.add(Localization.translate((String)"itemtooltip", (String)"waterboltweapontip"));
        tooltips.add("Bounces: " + 3.0f * this.getUpgradeTier(item));
        tooltips.add("Piercing: " + 2.0f * this.getUpgradeTier(item));
        return tooltips;
    }

    public void showAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, int animAttack, int seed, GNDItemMap mapContent) {
        if (level.isClient()) {
            SoundManager.playSound((GameSound)GameResources.magicbolt1, (SoundEffect)SoundEffect.effect((PrimitiveSoundEmitter)attackerMob).volume(0.7f).pitch(GameRandom.globalRandom.getFloatBetween(1.0f, 1.1f)));
        }
    }

    public InventoryItem onAttack(Level level, int x, int y, ItemAttackerMob attackerMob, int attackHeight, InventoryItem item, ItemAttackSlot slot, int animAttack, int seed, GNDItemMap mapContent) {
        PlayerMob player;
        if (attackerMob instanceof PlayerMob && (player = (PlayerMob)attackerMob).getMana() >= this.getManaCost(item)) {
            int defaultBounces = 3;
            int defaultPiercing = 2;
            WaterBoltProjectile projectile = new WaterBoltProjectile(level, (Mob)player, player.x, player.y, x, y, this.getProjectileVelocity(item, (Mob)player), this.getAttackRange(item), this.getAttackDamage(item), this.getKnockback(item, (Attacker)player), defaultBounces * (int)this.getUpgradeTier(item), defaultPiercing * (int)this.getUpgradeTier(item));
            GameRandom random = new GameRandom((long)seed);
            projectile.resetUniqueID(random);
            projectile.moveDist(40.0);
            level.entityManager.projectiles.addHidden((Entity)projectile);
            if (level.isServer()) {
                level.getServer().network.sendToClientsWithEntityExcept((Packet)new PacketSpawnProjectile((Projectile)projectile), (RegionPositionGetter)projectile, player.getServerClient());
            }
            this.consumeMana((ItemAttackerMob)player, item);
        }
        return item;
    }
}

